/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.nuxeo.runtime.datasource.DataSourceHelper;

public class NuxeoConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = 1L;
    protected DataSource ds;

    public void configure(Map props) {
        Object value = props.get("hibernate.connection.datasource");
        if (value instanceof DataSource) {
            this.ds = (DataSource)value;
        } else {
            String name = (String)value;
            try {
                this.ds = DataSourceHelper.getDataSource((String)name);
            }
            catch (NamingException cause) {
                throw new HibernateException("Cannot lookup datasource by name " + name, (Throwable)cause);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void stop() {
        this.ds = null;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || NuxeoConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || NuxeoConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.ds;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }
}

