/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;
import org.nuxeo.ecm.core.persistence.HibernateConfiguration;
import org.nuxeo.ecm.core.persistence.HibernateConfigurator;
import org.nuxeo.ecm.core.persistence.PersistenceError;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class PersistenceComponent
extends DefaultComponent
implements HibernateConfigurator,
PersistenceProviderFactory {
    protected static final String XP = "hibernate";

    public int getApplicationStartedOrder() {
        return 50;
    }

    public void start(ComponentContext context) {
        this.getRegistryContributions(XP).forEach(desc -> {
            PersistenceProvider pp = new PersistenceProvider((EntityManagerFactoryProvider)desc);
            pp.openPersistenceUnit();
            pp.closePersistenceUnit();
        });
    }

    @Override
    public PersistenceProvider newProvider(String name) {
        return new PersistenceProvider(this.getHibernateConfiguration(name));
    }

    @Override
    public HibernateConfiguration getHibernateConfiguration(String name) {
        return (HibernateConfiguration)this.getRegistryContribution(XP, name).orElseThrow(() -> new PersistenceError(String.format("No hibernate configuration identified by '%s' is available", name)));
    }
}

