/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.suggestbox.service.ComponentInitializationException;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionService;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterGroupDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterGroupItemDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.registries.SuggesterGroupRegistry;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class SuggestionServiceImpl
extends DefaultComponent
implements SuggestionService {
    private static final Logger log = LogManager.getLogger(SuggestionServiceImpl.class);
    protected static final String SUGGESTERS_XP = "suggesters";
    protected static final String SUGGESTERGROUPS_XP = "suggesterGroups";
    protected Map<String, Suggester> suggesters;

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        SuggesterGroupDescriptor suggesterGroup = this.getSuggesterGroups().getSuggesterGroupDescriptor(context.suggesterGroup);
        if (suggesterGroup == null) {
            log.warn("No registered SuggesterGroup with id: {}", (Object)context.suggesterGroup);
            return suggestions;
        }
        for (SuggesterGroupItemDescriptor suggesterGroupItem : suggesterGroup.getSuggesters()) {
            String suggesterName = suggesterGroupItem.getName();
            Suggester suggester = this.suggesters.get(suggesterName);
            if (suggester == null) {
                log.warn("No suggester available with name '{}'", (Object)suggesterName);
                continue;
            }
            suggestions.addAll(suggester.suggest(userInput, context));
        }
        return suggestions;
    }

    @Override
    public List<Suggestion> suggest(String input, SuggestionContext context, String suggesterName) throws SuggestionException {
        Suggester suggester = this.suggesters.get(suggesterName);
        if (suggester == null) {
            throw new SuggestionException(String.format("No suggester available with name '%s'.", suggesterName));
        }
        return suggester.suggest(input, context);
    }

    public void start(ComponentContext context) {
        this.suggesters = new HashMap<String, Suggester>();
        this.getRegistryContributions(SUGGESTERS_XP).forEach(desc -> {
            try {
                this.suggesters.put(desc.getName(), desc.getSuggester());
            }
            catch (ComponentInitializationException e) {
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, e.getMessage());
                log.error((Object)e, (Throwable)e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.suggesters = null;
    }

    public SuggesterGroupRegistry getSuggesterGroups() {
        return (SuggesterGroupRegistry)this.getExtensionPointRegistry(SUGGESTERGROUPS_XP);
    }
}

