/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.EventBundleImpl;
import org.nuxeo.ecm.core.event.script.Script;
import org.nuxeo.ecm.core.event.script.ScriptingEventListener;
import org.nuxeo.ecm.core.event.script.ScriptingPostCommitEventListener;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="listener")
@XRegistry(enable=false)
public class EventListenerDescriptor {
    public static final Log log = LogFactory.getLog(EventListenerDescriptor.class);
    @XNode(value="@name")
    protected String name;
    @XNode(value="@class")
    protected String className;
    @XNode(value="@script")
    protected String script;
    @XNode(value="@postCommit")
    protected boolean isPostCommit;
    @XNode(value="@async")
    protected Boolean isAsync;
    @XNode(value="@transactionTimeOut")
    protected Integer transactionTimeOut;
    @XNode(value="@priority")
    protected Integer priority;
    @XNode(value="@enable", fallback="@enabled", defaultAssignment="true")
    @XEnable
    protected boolean isEnabled = true;
    @XNode(value="@retryCount")
    protected Integer retryCount;
    @XNode(value="@singlethread")
    protected boolean singleThreaded = false;
    @XNodeList(value="event", componentType=String.class, type=HashSet.class, nullByDefault=true)
    protected Set<String> events;
    protected RuntimeContext context;
    protected EventListener inLineListener;
    protected PostCommitEventListener postCommitEventListener;

    public int getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public void initListener(Context context) {
        block8: {
            try {
                if (this.className != null) {
                    Class klass = context.loadClass(this.className);
                    if (EventListener.class.isAssignableFrom(klass)) {
                        this.inLineListener = (EventListener)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.isPostCommit = false;
                        break block8;
                    }
                    if (PostCommitEventListener.class.isAssignableFrom(klass)) {
                        this.postCommitEventListener = (PostCommitEventListener)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.isPostCommit = true;
                        break block8;
                    }
                    throw new IllegalArgumentException("Listener extension must define a class extending EventListener or PostCommitEventListener: '" + this.className + "'.");
                }
                if (this.script != null) {
                    Script script = this.getScript(context);
                    if (this.isPostCommit) {
                        this.postCommitEventListener = new ScriptingPostCommitEventListener(script);
                    } else {
                        this.inLineListener = new ScriptingEventListener(script);
                    }
                    break block8;
                }
                throw new IllegalArgumentException("Listener extension must define either a class or a script");
            }
            catch (IOException | NoClassDefFoundError | ReflectiveOperationException e) {
                throw new NuxeoException(e);
            }
        }
    }

    public EventListener asEventListener() {
        return this.inLineListener;
    }

    public PostCommitEventListener asPostCommitListener() {
        return this.postCommitEventListener;
    }

    public Script getScript(Context context) throws IOException {
        if (context != null) {
            URL url = context.getResource(this.script);
            if (url == null) {
                throw new IOException("Script Not found: " + this.script);
            }
            return Script.newScript(url);
        }
        return Script.newScript(this.script);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.className != null ? this.className : this.script;
        }
        return this.name;
    }

    public Integer getTransactionTimeout() {
        return this.transactionTimeOut;
    }

    public final boolean acceptEvent(String eventName) {
        return this.events == null || this.events.contains(eventName);
    }

    public boolean getIsAsync() {
        return Boolean.TRUE.equals(this.isAsync);
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public EventBundle filterBundle(EventBundle bundle) {
        EventBundleImpl filtered = new EventBundleImpl();
        for (Event event : bundle) {
            PostCommitEventListener pcl;
            if (!this.acceptEvent(event.getName()) || (pcl = this.asPostCommitListener()) instanceof PostCommitFilteringEventListener && !((PostCommitFilteringEventListener)pcl).acceptEvent(event)) continue;
            filtered.push(event);
        }
        return filtered;
    }

    public boolean acceptBundle(EventBundle bundle) {
        for (Event event : bundle) {
            PostCommitEventListener pcl;
            if (!this.acceptEvent(event.getName()) || (pcl = this.asPostCommitListener()) instanceof PostCommitFilteringEventListener && !((PostCommitFilteringEventListener)pcl).acceptEvent(event)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "EventListenerDescriptor [name=" + this.name + ", className=" + this.className + ", isPostCommit=" + this.isPostCommit + ", isAsync=" + this.isAsync + "]";
    }
}

