/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.scheduler.EventJobFactory;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.matchers.GroupMatcher;

public class SchedulerServiceImpl
extends DefaultComponent
implements SchedulerService,
ComponentManager.Listener {
    private static final Log log = LogFactory.getLog(SchedulerServiceImpl.class);
    public static final String CLUSTER_START_DURATION_PROP = "org.nuxeo.scheduler.cluster.start.duration";
    public static final Duration CLUSTER_START_DURATION_DEFAULT = Duration.ofMinutes(1L);
    protected static final String XP = "schedule";
    protected Scheduler scheduler;
    private Map<String, JobKey> jobKeys = new HashMap<String, JobKey>();

    protected void setupScheduler() throws IOException, SchedulerException {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        File file = new File(Environment.getDefault().getConfig(), "quartz.properties");
        if (file.exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                schedulerFactory.initialize((InputStream)stream);
            }
        } else {
            Properties props = new Properties();
            props.put("org.quartz.scheduler.instanceName", "Quartz");
            props.put("org.quartz.scheduler.threadName", "Quartz_Scheduler");
            props.put("org.quartz.scheduler.instanceId", "NON_CLUSTERED");
            props.put("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            props.put("org.quartz.scheduler.skipUpdateCheck", "true");
            props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            props.put("org.quartz.threadPool.threadCount", "1");
            props.put("org.quartz.threadPool.threadPriority", "4");
            props.put("org.quartz.threadPool.makeThreadsDaemons", "true");
            schedulerFactory.initialize(props);
        }
        this.scheduler = schedulerFactory.getScheduler();
        this.scheduler.start();
        GroupMatcher matcher = GroupMatcher.jobGroupEquals((String)"nuxeo");
        Set jobs = this.scheduler.getJobKeys(matcher);
        try {
            this.scheduler.deleteJobs(new ArrayList(jobs));
            this.getRegistryContributions(XP).forEach(this::registerSchedule);
        }
        catch (LockException cause) {
            log.warn((Object)"scheduler already re-initializing, another cluster node concurrent startup ?", (Throwable)cause);
        }
        log.info((Object)"scheduler started");
    }

    protected void shutdownScheduler() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException cause) {
            log.error((Object)"Cannot shutdown scheduler", (Throwable)cause);
        }
        finally {
            this.scheduler = null;
        }
    }

    public void deactivate(ComponentContext context) {
        log.debug((Object)"Deactivate");
        this.shutdownScheduler();
    }

    public void afterRuntimeStart(ComponentManager mgr, boolean isResume) {
        this.startScheduler();
    }

    protected void startScheduler() {
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        String prop = Framework.getProperty((String)CLUSTER_START_DURATION_PROP);
        Duration duration = DurationUtils.parsePositive((String)prop, (Duration)CLUSTER_START_DURATION_DEFAULT);
        Duration pollDelay = Duration.ofSeconds(1L);
        clusterService.runAtomically("start-scheduler", duration, pollDelay, () -> {
            try {
                this.setupScheduler();
            }
            catch (IOException | SchedulerException e) {
                throw new NuxeoException(e);
            }
        });
    }

    public void stop(ComponentContext context) {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.standby();
        }
        catch (SchedulerException cause) {
            log.error((Object)"Cannot put scheduler in stand by mode", (Throwable)cause);
        }
    }

    @Override
    public boolean hasApplicationStarted() {
        return this.scheduler != null;
    }

    protected void registerSchedule(Schedule schedule) {
        this.registerSchedule(schedule, null);
    }

    protected void registerSchedule(Schedule schedule, Map<String, Serializable> parameters) {
        if (this.scheduler == null || schedule == null) {
            return;
        }
        String id = schedule.getId();
        this.getRegistryContribution(XP, id).ifPresentOrElse(c -> this.schedule((Schedule)c, parameters), () -> this.unschedule(id));
    }

    protected void schedule(Schedule schedule, Map<String, Serializable> parameters) {
        log.info((Object)("Registering " + schedule));
        EventJobFactory jobFactory = schedule.getJobFactory();
        JobDetail job = jobFactory.buildJob(schedule, parameters).build();
        Trigger trigger = jobFactory.buildTrigger(schedule).build();
        try {
            try {
                this.schedule(schedule.getId(), job, trigger);
            }
            catch (ObjectAlreadyExistsException e) {
                log.trace((Object)("Overriding scheduler with id: " + schedule.getId()));
                boolean unregistered = this.unschedule(schedule.getId(), job.getKey());
                if (unregistered) {
                    this.schedule(schedule.getId(), job, trigger);
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to schedule job with id '%s': %s", schedule.getId(), e.getMessage()), (Throwable)e);
        }
    }

    protected void schedule(String id, JobDetail job, Trigger trigger) throws SchedulerException {
        this.scheduler.scheduleJob(job, trigger);
        this.jobKeys.put(id, job.getKey());
    }

    protected boolean unschedule(String id) {
        return this.unschedule(id, this.jobKeys.remove(id));
    }

    protected boolean unschedule(String id, JobKey jobKey) {
        if (jobKey == null) {
            log.warn((Object)("Unscheduling null jobKey for id: " + id));
            return false;
        }
        try {
            return this.scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to unschedule job with '%s': %s", id, e.getMessage()), (Throwable)e);
            return true;
        }
    }
}

