/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.nuxeo.ecm.core.work.BaseOverflowRecordFilter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;

public class KeyValueStoreOverflowRecordFilter
extends BaseOverflowRecordFilter {
    private static final String INIT_KEY = "_init_";

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.getKeyValueStore().put(this.getPrefixedKey(INIT_KEY), INIT_KEY.getBytes(StandardCharsets.UTF_8), 60L);
    }

    protected KeyValueStore getKeyValueStore() {
        return ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore(this.getStoreName());
    }

    @Override
    protected void storeValue(String recordKey, byte[] data) {
        String key = this.getPrefixedKey(recordKey);
        this.getKeyValueStore().put(key, data, this.getStoreTTL().toSeconds());
    }

    @Override
    protected byte[] fetchValue(String recordKey) {
        String key = this.getPrefixedKey(recordKey);
        return this.getKeyValueStore().get(key);
    }
}

