/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkStateHelper;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class WorkComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(WorkComputation.class);
    protected static final int IDS_SIZE = 50;
    protected final CircularFifoBuffer workIds = new CircularFifoBuffer(50);
    protected final Timer workTimer;
    protected final long stateTTL;
    protected Work work;

    public WorkComputation(String name) {
        super(name, 1, 0);
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.workTimer = registry.timer(MetricName.build((String[])new String[]{"nuxeo.works.queue.timer"}).tagged(new String[]{"queue", Name.ofUrn((String)name).getName()}));
        this.stateTTL = ((ConfigurationService)Framework.getService(ConfigurationService.class)).getLong("nuxeo.stream.work.state.ttl.seconds", 3600L);
    }

    public void signalStop() {
        if (this.work != null) {
            this.work.setWorkInstanceSuspending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        this.work = WorkComputation.deserialize(record.getData());
        try {
            if (this.work.isCoalescing() && WorkStateHelper.getLastOffset(this.work.getId()) > context.getLastOffset().offset()) {
                log.debug("Skipping duplicate of coalescing work id: " + this.work.getId() + " " + this.work);
            } else if (this.work.isIdempotent() && this.workIds.contains((Object)this.work.getId())) {
                log.debug("Skipping duplicate of idempotent work id: " + this.work.getId());
            } else {
                boolean storeState = ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue("nuxeo.stream.work.storestate.enabled");
                if (storeState) {
                    if (WorkStateHelper.getState(this.work.getId()) != Work.State.SCHEDULED) {
                        Thread.sleep(200L);
                        if (WorkStateHelper.getState(this.work.getId()) != Work.State.SCHEDULED) {
                            log.warn("work has been canceled, saving and returning");
                            context.askForCheckpoint();
                            return;
                        }
                        log.warn("Race condition avoided on " + this.work.getId());
                    }
                    WorkStateHelper.setState(this.work.getId(), Work.State.RUNNING, this.stateTTL);
                }
                this.work.setWorkInstanceState(Work.State.RUNNING);
                new WorkHolder(this.work).run();
                if (storeState && WorkStateHelper.getState(this.work.getId()) == Work.State.RUNNING) {
                    WorkStateHelper.setState(this.work.getId(), null, this.stateTTL);
                }
                this.workIds.add((Object)this.work.getId());
            }
            this.work.cleanUp(true, null);
            if (!this.work.isWorkInstanceSuspended()) {
                context.askForCheckpoint();
            }
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted() || ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                Thread.currentThread().interrupt();
                log.warn(String.format("Work id: %s title: %s, has been interrupted the work thread is terminating, it will be rescheduled, record: %s", this.work.getId(), this.work.getTitle(), record), (Throwable)e);
            } else {
                log.error(String.format("Skip Work in failure: id: %s, title: %s, offset: %s, record: %s, thread: %s", this.work.getId(), this.work.getTitle(), context.getLastOffset(), record, Thread.currentThread().getName()), (Throwable)e);
                context.askForCheckpoint();
            }
            log.debug("Exception during work " + this.work.getId(), (Throwable)e);
            this.cleanupWorkInFailure(this.work, e);
        }
        finally {
            this.workTimer.update(this.work.getCompletionTime() - this.work.getStartTime(), TimeUnit.MILLISECONDS);
            this.work = null;
        }
    }

    protected void cleanupWorkInFailure(Work work, Exception exception) {
        try {
            work.cleanUp(false, exception);
        }
        catch (Exception e) {
            log.error("Error during cleanup work: " + work.getId(), (Throwable)e);
        }
    }

    public static Work deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Work work = (Work)in.readObject();
            return work;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Work work) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(work);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

