/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.standby;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import javax.management.JMException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.management.standby.StandbyCommand;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventHandler;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventListener;

public class StandbyComponent
extends DefaultComponent {
    protected final StandbyCommand command = new StandbyCommand();
    protected MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter active = this.registry.counter(MetricRegistry.name(StandbyComponent.class, (String[])new String[]{"active"}));
    protected final Meter meter = this.registry.meter(MetricRegistry.name(StandbyComponent.class, (String[])new String[]{"meter"}));
    protected final Timer timer = this.registry.timer(MetricRegistry.name(StandbyComponent.class, (String[])new String[]{"timer"}));
    protected final ThreadLocal<Timer.Context> holder = new ThreadLocal();
    protected final ThreadEventListener threadsListener = new ThreadEventListener(new ThreadEventHandler(){

        public void onEnter(boolean isLongRunning) {
            if (isLongRunning) {
                return;
            }
            StandbyComponent.this.holder.set(StandbyComponent.this.timer.time());
            StandbyComponent.this.meter.mark();
            StandbyComponent.this.active.inc();
        }

        public void onLeave() {
            StandbyComponent.this.active.dec();
            StandbyComponent.this.holder.get().close();
        }
    });

    public void activate(ComponentContext context) {
        this.threadsListener.install();
        try {
            this.command.registration.with(((ServerLocator)Framework.getService(ServerLocator.class)).lookupServer()).register();
        }
        catch (JMException cause) {
            throw new NuxeoException("Cannot register standby command", (Throwable)cause);
        }
    }

    public void deactivate(ComponentContext context) {
        this.threadsListener.uninstall();
        try {
            this.command.registration.unregister();
        }
        catch (JMException cause) {
            throw new NuxeoException("Cannot unregister standby command", (Throwable)cause);
        }
    }
}

