/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.RatioGauge;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.io.Serializable;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheWrapper;
import org.nuxeo.runtime.metrics.MetricsService;

public class CacheMetrics
extends CacheWrapper {
    protected MetricRegistry registry;
    protected Counter read;
    protected Counter read_hit;
    protected Counter read_miss;
    protected RatioGauge read_hit_ratio;
    protected Counter write;
    protected Counter invalidation;
    protected Gauge<Long> size;
    protected final MetricName READ_HIT_NAME = this.nameOf("hit");
    protected final MetricName READ_HIT_RATIO_NAME = this.nameOf("hit.ratio");
    protected final MetricName READ_MISS_NAME = this.nameOf("miss");
    protected final MetricName READ_NAME = this.nameOf("read");
    protected final MetricName WRITE_NAME = this.nameOf("write");
    protected final MetricName INVALIDATE_ALL_NAME = this.nameOf("invalidation");
    protected final MetricName SIZE_NAME = this.nameOf("size");

    protected MetricName nameOf(String name) {
        return MetricName.build((String[])new String[]{"nuxeo", "cache", name}).tagged(new String[]{"cache", this.getName()});
    }

    public CacheMetrics(CacheManagement cache) {
        super(cache);
    }

    @Override
    public void start() {
        this.registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.read = this.registry.counter(this.READ_NAME);
        this.read_hit = this.registry.counter(this.READ_HIT_NAME);
        this.read_miss = this.registry.counter(this.READ_MISS_NAME);
        this.read_hit_ratio = new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                RatioGauge.Ratio ratio = RatioGauge.Ratio.of((double)CacheMetrics.this.read_hit.getCount(), (double)CacheMetrics.this.read.getCount());
                return ratio;
            }
        };
        this.registry.register(this.READ_HIT_RATIO_NAME, (Metric)this.read_hit_ratio);
        this.write = this.registry.counter(this.WRITE_NAME);
        this.invalidation = this.registry.counter(this.INVALIDATE_ALL_NAME);
        this.size = new Gauge<Long>(){

            public Long getValue() {
                return CacheMetrics.this.getSize();
            }
        };
        this.registry.register(this.SIZE_NAME, (Metric)this.size);
    }

    @Override
    public void stop() {
        this.registry.remove(this.READ_NAME);
        this.registry.remove(this.READ_HIT_NAME);
        this.registry.remove(this.READ_MISS_NAME);
        this.registry.remove(this.READ_HIT_RATIO_NAME);
        this.registry.remove(this.WRITE_NAME);
        this.registry.remove(this.INVALIDATE_ALL_NAME);
        this.registry.remove(this.SIZE_NAME);
    }

    @Override
    public Serializable get(String key) {
        Serializable value = super.get(key);
        this.read.inc();
        if (value != null || super.hasEntry(key)) {
            this.read_hit.inc();
        } else {
            this.read_miss.inc();
        }
        return value;
    }

    @Override
    public void put(String key, Serializable value) {
        try {
            super.put(key, value);
        }
        finally {
            this.write.inc();
        }
    }

    @Override
    public void invalidateAll() {
        try {
            super.invalidateAll();
        }
        finally {
            this.invalidation.inc();
        }
    }
}

