/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class FileIterator
implements Iterator<File>,
Enumeration<File> {
    protected FileFilter filter;
    protected Queue<File> files = new LinkedList<File>();
    protected File file;
    protected boolean skipDirs = false;

    public static Iterator<URL> asUrlIterator(final Iterator<File> it) {
        return new Iterator<URL>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public URL next() {
                try {
                    return ((File)it.next()).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static Enumeration<URL> asUrlEnumeration(final Iterator<File> it) {
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public URL nextElement() {
                try {
                    return ((File)it.next()).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public FileIterator(File file) {
        this(file, null);
    }

    public FileIterator(File file, FileFilter filter) {
        this.filter = filter;
        this.feed(file);
    }

    public void setSkipDirs(boolean skipDirs) {
        this.skipDirs = skipDirs;
    }

    public boolean getSkipDirs() {
        return this.skipDirs;
    }

    @Override
    public boolean hasNext() {
        if (this.file != null) {
            return true;
        }
        this.file = this.files.poll();
        if (this.file == null) {
            return false;
        }
        if (this.skipDirs) {
            while (this.file != null && this.file.isDirectory()) {
                this.feed(this.file);
                this.file = this.files.poll();
            }
        } else {
            this.feed(this.file);
        }
        return this.file != null;
    }

    @Override
    public File next() {
        if (this.file == null) {
            this.hasNext();
            if (this.file == null) {
                throw new NoSuchElementException();
            }
        }
        File f = this.file;
        this.file = null;
        return f;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove ot supported");
    }

    public void feed(File file) {
        File[] content = file.listFiles(this.filter);
        if (content != null) {
            this.files.addAll(Arrays.asList(content));
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public File nextElement() {
        return this.next();
    }
}

