/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LogEntryJsonWriter
extends ExtensibleEntityJsonWriter<LogEntry> {
    public static final String ENTITY_TYPE = "logEntry";

    public LogEntryJsonWriter() {
        super(ENTITY_TYPE, LogEntry.class);
    }

    protected void writeEntityBody(LogEntry logEntry, JsonGenerator jg) throws IOException {
        jg.writeNumberField("id", logEntry.getId());
        jg.writeStringField("category", logEntry.getCategory());
        jg.writeStringField("principalName", logEntry.getPrincipalName());
        jg.writeStringField("comment", logEntry.getComment());
        jg.writeStringField("docLifeCycle", logEntry.getDocLifeCycle());
        jg.writeStringField("docPath", logEntry.getDocPath());
        jg.writeStringField("docType", logEntry.getDocType());
        jg.writeStringField("docUUID", logEntry.getDocUUID());
        jg.writeStringField("eventId", logEntry.getEventId());
        jg.writeStringField("repositoryId", logEntry.getRepositoryId());
        jg.writeStringField("eventDate", DateUtils.formatISODateTime((Date)DateUtils.nowIfNull((Date)logEntry.getEventDate())));
        jg.writeStringField("logDate", DateUtils.formatISODateTime((Date)DateUtils.nowIfNull((Date)logEntry.getLogDate())));
        this.writeExtendedInfos(jg, logEntry);
    }

    protected void writeExtendedInfos(JsonGenerator jg, LogEntry logEntry) throws IOException {
        Map extended = logEntry.getExtendedInfos();
        jg.writeObjectFieldStart("extended");
        for (String key : extended.keySet()) {
            ExtendedInfo ei = (ExtendedInfo)extended.get(key);
            if (ei != null && ei.getSerializableValue() != null) {
                this.writeExtendedInfo(jg, key, ei.getSerializableValue());
                continue;
            }
            jg.writeNullField(key);
        }
        jg.writeEndObject();
    }

    protected void writeExtendedInfo(JsonGenerator jg, String key, Serializable value) throws IOException {
        Class<?> clazz = value.getClass();
        if (Long.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Long)value).longValue());
        } else if (Integer.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Integer)value).intValue());
        } else if (Double.class.isAssignableFrom(clazz)) {
            jg.writeNumberField(key, ((Double)value).doubleValue());
        } else if (Date.class.isAssignableFrom(clazz)) {
            jg.writeStringField(key, DateUtils.formatISODateTime((Date)((Date)value)));
        } else if (String.class.isAssignableFrom(clazz)) {
            jg.writeStringField(key, (String)((Object)value));
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            jg.writeBooleanField(key, ((Boolean)value).booleanValue());
        } else if (clazz.isArray() || List.class.isAssignableFrom(clazz)) {
            jg.writeObjectField(key, (Object)value);
        } else if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)((Object)value);
            jg.writeObjectFieldStart(key);
            for (Map.Entry entry : map.entrySet()) {
                Serializable v = (Serializable)entry.getValue();
                if (v == null || v instanceof Blob) continue;
                this.writeExtendedInfo(jg, (String)entry.getKey(), v);
            }
            jg.writeEndObject();
        } else {
            jg.writeStringField(key, value.toString());
        }
    }
}

