/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.DefaultAuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.DefaultComponent;

@XObject(value="backend")
@XRegistry(merge=false)
public class AuditBackendDescriptor {
    private static final Logger log = LogManager.getLogger(AuditBackendDescriptor.class);
    @XNode(value="@class")
    protected Class<? extends AuditBackend> klass = DefaultAuditBackend.class;
    @XNodeList(value="require", type=ArrayList.class, componentType=String.class)
    protected List<String> requires;

    public int getApplicationStartedOrder() {
        for (String require : this.requires) {
            if (Framework.getRuntime().getComponent(require) != null) continue;
            log.warn("Unknown required component '{}' for AuditBackendDescriptor using '{}'", (Object)require, this.klass);
        }
        return this.requires.stream().map(arg_0 -> ((RuntimeService)Framework.getRuntime()).getComponent(arg_0)).filter(Objects::nonNull).map(DefaultComponent.class::cast).mapToInt(Component::getApplicationStartedOrder).max().orElse(1000) + 1;
    }

    public Class<? extends AuditBackend> getKlass() {
        return this.klass;
    }

    public AuditBackend newInstance(NXAuditEventsService component) {
        try {
            return this.klass.getDeclaredConstructor(NXAuditEventsService.class, AuditBackendDescriptor.class).newInstance(new Object[]{component, this});
        }
        catch (ReflectiveOperationException cause) {
            throw new RuntimeException("Cannot create audit backend of type " + this.klass.getName(), cause);
        }
    }
}

