/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.net.URL;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodes;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.BundleResourceResolver;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FileResourceResolver;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourceResolver;
import org.nuxeo.runtime.model.impl.XMapContext;
import org.osgi.framework.Bundle;

@XObject(value="resources")
@XRegistry(compatWarnOnMerge=true)
@XRegistryId(value={"@servlet", "@path"})
public class ResourcesDescriptor {
    @XNode
    protected Context ctx;
    @XNodes(values={"@servlet", "@path"})
    protected String resolverId;
    @XNode(value="@servlet")
    protected String servlet;
    @XNode(value="@path")
    protected String path;
    private ResourceResolver resolver;

    public Bundle getBundle() {
        if (this.ctx instanceof XMapContext) {
            return ((XMapContext)this.ctx).getRuntimeContext().getBundle();
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public String getServlet() {
        return this.servlet;
    }

    public String getId() {
        Bundle bundle = this.getBundle();
        return (bundle != null ? bundle.getSymbolicName() : "") + ":" + this.resolverId;
    }

    protected ResourceResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = this.path != null && this.path.startsWith("file:") ? new FileResourceResolver(this.path.substring("file:".length())) : new BundleResourceResolver(this.getBundle(), this.path);
        }
        return this.resolver;
    }

    public URL getResource(String name) {
        return this.getResolver().getResource(name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourcesDescriptor) {
            return this.getId().equals(((ResourcesDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }
}

