/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.time.Duration;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;

public class RouteModelsInitializator
extends RepositoryInitializationHandler {
    public static final String CLUSTER_START_DURATION_PROP = "org.nuxeo.workflow.cluster.start.duration";
    public static final Duration CLUSTER_START_DURATION_DEFAULT = Duration.ofMinutes(1L);

    public void doInitializeRepository(CoreSession session) {
        String repositoryName = session.getRepositoryName();
        String prop = Framework.getProperty((String)CLUSTER_START_DURATION_PROP);
        Duration duration = DurationUtils.parsePositive((String)prop, (Duration)CLUSTER_START_DURATION_DEFAULT);
        Duration pollDelay = Duration.ofSeconds(1L);
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        clusterService.runAtomically("start-workflows-" + repositoryName, duration, pollDelay, () -> this.importWorkflows(repositoryName));
    }

    protected void importWorkflows(String repositoryName) {
        DocumentRoutingService service = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        CoreInstance.doPrivileged((String)repositoryName, session -> {
            service.importAllRouteModels(session);
            session.save();
        });
    }
}

