/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.DateRangeIncludingNowQuery;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;

public final class DateFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(DateFieldMapper.class));
    public static final String CONTENT_TYPE = "date";
    public static final String DATE_NANOS_CONTENT_TYPE = "date_nanos";
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis");
    private Explicit<Boolean> ignoreMalformed;
    private final Long nullValue;
    private final String nullValueAsString;

    private DateFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Long nullValue, String nullValueAsString, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.nullValue = nullValue;
        this.nullValueAsString = nullValueAsString;
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().resolution.type();
    }

    @Override
    protected DateFieldMapper clone() {
        return (DateFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        long timestamp;
        Object dateAsObject;
        Object dateAsString = context.externalValueSet() ? ((dateAsObject = context.externalValue()) == null ? null : dateAsObject.toString()) : context.parser().textOrNull();
        if (dateAsString == null) {
            if (this.nullValue == null) {
                return;
            }
            timestamp = this.nullValue;
        } else {
            try {
                timestamp = this.fieldType().parse((String)dateAsString);
            }
            catch (IllegalArgumentException | DateTimeException | ElasticsearchParseException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
        }
        if (this.mappedFieldType.isSearchable()) {
            context.doc().add((IndexableField)new LongPoint(this.fieldType().name(), new long[]{timestamp}));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        } else if (this.fieldType.stored() || this.mappedFieldType.isSearchable()) {
            this.createFieldNamesField(context);
        }
        if (this.fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), timestamp));
        }
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        DateFieldMapper d = (DateFieldMapper)other;
        if (!Objects.equals(this.fieldType().dateTimeFormatter.pattern(), d.fieldType().dateTimeFormatter.pattern())) {
            conflicts.add("mapper [" + this.name() + "] has different [format] values");
        }
        if (!Objects.equals(this.fieldType().dateTimeFormatter.locale(), d.fieldType().dateTimeFormatter.locale())) {
            conflicts.add("mapper [" + this.name() + "] has different [locale] values");
        }
        if (!Objects.equals(this.fieldType().resolution.type(), d.fieldType().resolution.type())) {
            conflicts.add("mapper [" + this.name() + "] cannot change between milliseconds and nanoseconds");
        }
        if (d.ignoreMalformed.explicit()) {
            this.ignoreMalformed = d.ignoreMalformed;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValueAsString);
        }
        if (includeDefaults || !this.fieldType().dateTimeFormatter().pattern().equals(DEFAULT_DATE_TIME_FORMATTER.pattern())) {
            builder.field("format", this.fieldType().dateTimeFormatter().pattern());
        }
        if (includeDefaults || !this.fieldType().dateTimeFormatter().locale().equals(DEFAULT_DATE_TIME_FORMATTER.locale())) {
            builder.field("locale", (Object)this.fieldType().dateTimeFormatter().locale());
        }
    }

    public Explicit<Boolean> getIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    public Long getNullValue() {
        return this.nullValue;
    }

    public static final class DateFieldType
    extends MappedFieldType {
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final Resolution resolution;

        public DateFieldType(String name, boolean isSearchable, boolean hasDocValues, DateFormatter dateTimeFormatter, Resolution resolution, Map<String, String> meta) {
            super(name, isSearchable, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
            this.resolution = resolution;
        }

        public DateFieldType(String name) {
            this(name, true, true, DEFAULT_DATE_TIME_FORMATTER, Resolution.MILLISECONDS, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public Resolution resolution() {
            return this.resolution;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        public long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value), this.dateTimeFormatter().locale()).toInstant());
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            long u;
            long l;
            this.failIfNotIndexed();
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser parser = forcedDateParser == null ? this.dateMathParser : forcedDateParser;
            boolean[] nowUsed = new boolean[1];
            LongSupplier nowSupplier = () -> {
                nowUsed[0] = true;
                return context.nowInMillis();
            };
            if (lowerTerm == null) {
                l = Long.MIN_VALUE;
            } else {
                l = this.parseToLong(lowerTerm, !includeLower, timeZone, parser, nowSupplier);
                if (!includeLower) {
                    ++l;
                }
            }
            if (upperTerm == null) {
                u = Long.MAX_VALUE;
            } else {
                u = this.parseToLong(upperTerm, includeUpper, timeZone, parser, nowSupplier);
                if (!includeUpper) {
                    --u;
                }
            }
            Query query = LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
            if (this.hasDocValues()) {
                Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            if (nowUsed[0]) {
                query = new DateRangeIncludingNowQuery(query);
            }
            return query;
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, @Nullable DateMathParser forcedDateParser, LongSupplier now) {
            DateMathParser dateParser = this.dateMathParser();
            if (forcedDateParser != null) {
                dateParser = forcedDateParser;
            }
            String strValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            Instant instant = dateParser.parse(strValue, now, roundUp, zone);
            return this.resolution.convert(instant);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = this.parseToLong(from, !includeLower, timeZone, dateParser, context::nowInMillis);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = this.parseToLong(to, includeUpper, timeZone, dateParser, context::nowInMillis);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (PointValues.size((IndexReader)reader, (String)this.name()) == 0L) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension((byte[])PointValues.getMinPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            long maxValue = LongPoint.decodeDimension((byte[])PointValues.getMaxPackedValue((IndexReader)reader, (String)this.name()), (int)0);
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isSearchable()) {
                return this.resolution()::parsePointAsMillis;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.resolution.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, Resolution.MILLISECONDS);
        }
    }

    public static enum Resolution {
        MILLISECONDS("date", IndexNumericFieldData.NumericType.DATE){

            @Override
            public long convert(Instant instant) {
                return instant.toEpochMilli();
            }

            @Override
            public Instant toInstant(long value) {
                return Instant.ofEpochMilli(value);
            }

            @Override
            public Instant clampToValidRange(Instant instant) {
                return instant;
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }
        }
        ,
        NANOSECONDS("date_nanos", IndexNumericFieldData.NumericType.DATE_NANOSECONDS){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLong(instant);
            }

            @Override
            public Instant toInstant(long value) {
                return DateUtils.toInstant(value);
            }

            @Override
            public Instant clampToValidRange(Instant instant) {
                return DateUtils.clampToNanosRange(instant);
            }

            @Override
            public long parsePointAsMillis(byte[] value) {
                return DateUtils.toMilliSeconds(LongPoint.decodeDimension((byte[])value, (int)0));
            }
        };

        private final String type;
        private final IndexNumericFieldData.NumericType numericType;

        private Resolution(String type, IndexNumericFieldData.NumericType numericType) {
            this.type = type;
            this.numericType = numericType;
        }

        public String type() {
            return this.type;
        }

        IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public abstract long convert(Instant var1);

        public abstract Instant toInstant(long var1);

        public abstract Instant clampToValidRange(Instant var1);

        public abstract long parsePointAsMillis(byte[] var1);

        public static Resolution ofOrdinal(int ord) {
            for (Resolution resolution : Resolution.values()) {
                if (ord != resolution.ordinal()) continue;
                return resolution;
            }
            throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final Resolution resolution;

        public TypeParser(Resolution resolution) {
            this.resolution = resolution;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.withResolution(this.resolution);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.format(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder::addMultiField, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private Boolean ignoreMalformed;
        private Explicit<String> format = new Explicit<String>(DEFAULT_DATE_TIME_FORMATTER.pattern(), false);
        private Locale locale;
        private Resolution resolution = Resolution.MILLISECONDS;
        String nullValue;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Locale locale() {
            return this.locale;
        }

        public String format() {
            return this.format.value();
        }

        public Builder format(String format) {
            this.format = new Explicit<String>(format, true);
            return this;
        }

        public Builder withResolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public boolean isFormatterSet() {
            return this.format.explicit();
        }

        private DateFormatter buildFormatter(Mapper.BuilderContext context) {
            String pattern = this.format.value();
            try {
                if (Joda.isJodaPattern(context.indexCreatedVersion(), pattern)) {
                    return Joda.forPattern(pattern).withLocale(this.locale);
                }
                return DateFormatter.forPattern(pattern).withLocale(this.locale);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error parsing [format] on field [" + this.name() + "]: " + e.getMessage(), e);
            }
        }

        private Long parseNullValue(DateFieldType fieldType) {
            if (this.nullValue == null) {
                return null;
            }
            try {
                return fieldType.parse(this.nullValue);
            }
            catch (Exception e) {
                DEPRECATION_LOGGER.deprecatedAndMaybeLog("date_field_null_value", "Error parsing [{}] as date in [null_value] on field [{}]; [null_value] will be ignored", this.nullValue, this.name);
                return null;
            }
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            DateFieldType ft = new DateFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.buildFormatter(context), this.resolution, this.meta);
            Long nullTimestamp = this.parseNullValue(ft);
            return new DateFieldMapper(this.name, this.fieldType, ft, this.ignoreMalformed(context), nullTimestamp, this.nullValue, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        }
    }
}

