/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect;

import java.util.UUID;
import org.nuxeo.directory.test.DirectoryFeature;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.RunnerFeature;

@Features(value={CoreFeature.class, DirectoryFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.core.cache"}), @Deploy(value={"org.nuxeo.ecm.core.mimetype"}), @Deploy(value={"org.nuxeo.ecm.platform.oauth"}), @Deploy(value={"org.nuxeo.ecm.default.config"}), @Deploy(value={"org.nuxeo.ecm.platform.query.api:OSGI-INF/pageprovider-framework.xml"}), @Deploy(value={"org.nuxeo.ecm.liveconnect"}), @Deploy(value={"org.nuxeo.ecm.liveconnect.test:OSGI-INF/test-box-config.xml"}), @Deploy(value={"org.nuxeo.ecm.liveconnect.test:OSGI-INF/test-googledrive-config.xml"})})
public class LiveConnectFeature
implements RunnerFeature {
    public static final String SERVICE_BOX_ID = "box";
    public static final String SERVICE_CORE_ID = "core";
    public static final String SERVICE_GOOGLE_DRIVE_ID = "googledrive";
    public static final String USER_ID = "tester@example.com";

    public static BlobInfo createBlobInfo(String serviceId, String fileId) {
        return LiveConnectFeature.createBlobInfo(serviceId, fileId, UUID.randomUUID().toString());
    }

    public static BlobInfo createBlobInfo(String serviceId, String fileId, String digest) {
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.key = serviceId + ":tester@example.com:" + fileId;
        blobInfo.digest = digest;
        return blobInfo;
    }

    public static BlobInfo createBlobInfo(String serviceId, String fileId, String digest, String revisionId) {
        BlobInfo blobInfo = new BlobInfo();
        blobInfo.key = serviceId + ":tester@example.com:" + fileId + ":" + revisionId;
        blobInfo.digest = digest;
        return blobInfo;
    }

    public static SimpleManagedBlob createBlob(String serviceId, String fileId) {
        return new SimpleManagedBlob(LiveConnectFeature.createBlobInfo(serviceId, fileId));
    }

    public static SimpleManagedBlob createBlob(String serviceId, String fileId, String digest) {
        return new SimpleManagedBlob(LiveConnectFeature.createBlobInfo(serviceId, fileId, digest));
    }

    public static SimpleManagedBlob createBlob(String serviceId, String fileId, String digest, String revisionId) {
        return new SimpleManagedBlob(LiveConnectFeature.createBlobInfo(serviceId, fileId, digest, revisionId));
    }
}

