/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.box;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.liveconnect.LiveConnectFeature;
import org.nuxeo.ecm.liveconnect.box.BoxBlobProvider;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={LiveConnectFeature.class})
public class TestBoxBlobProvider {
    protected static final String FILE_1_ID = "5000948880";
    protected static final int FILE_1_SIZE = 629644;
    protected static final String FILE_1_NAME = "tigers.jpeg";
    @Inject
    private BlobManager blobManager;
    private BoxBlobProvider blobProvider;

    @Before
    public void before() {
        this.blobProvider = (BoxBlobProvider)Mockito.spy((Object)((BoxBlobProvider)this.blobManager.getBlobProvider("box")));
        Assert.assertNotNull((Object)this.blobProvider);
    }

    @Test
    public void testFreezeVersionWithBlobWithRevision() throws Exception {
        SimpleManagedBlob blob = LiveConnectFeature.createBlob("box", FILE_1_ID, "digest", "revision");
        ManagedBlob newBlob = this.blobProvider.freezeVersion((ManagedBlob)blob, null);
        Assert.assertNull((Object)newBlob);
    }

    @Test
    public void testFreezeVersion() throws Exception {
        SimpleManagedBlob blob = LiveConnectFeature.createBlob("box", FILE_1_ID);
        ManagedBlob newBlob = this.blobProvider.freezeVersion((ManagedBlob)blob, null);
        Assert.assertNotNull((Object)newBlob);
        Assert.assertEquals((Object)(blob.getKey() + ":26261748416"), (Object)newBlob.getKey());
    }
}

