/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.liveconnect.core.AbstractLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.core.MockLiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.TestLiveConnectBlobProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;

public class MockLiveConnectBlobProvider
extends AbstractLiveConnectBlobProvider<OAuth2ServiceProvider> {
    protected String getCacheName() {
        return "core";
    }

    protected String getPageProviderNameForUpdate() {
        return "core_document_to_be_updated";
    }

    protected LiveConnectFile retrieveFile(LiveConnectFileInfo fileInfo) throws IOException {
        if ("invalid-file-id".equals(fileInfo.getFileId())) {
            throw new IOException("Invalid file id: invalid-file-id");
        }
        return new MockLiveConnectFile(fileInfo, "tigers.jpeg", 629644L, TestLiveConnectBlobProvider.FILE_1_DIGEST);
    }

    public InputStream getStream(ManagedBlob blob) throws IOException {
        String key = blob.getKey();
        if ("core:tester@example.com:invalid-file-id".equals(key)) {
            throw new IOException("Invalid file id: invalid-file-id");
        }
        if ("core:tester@example.com:5000948880".equals(key)) {
            return new ByteArrayInputStream(TestLiveConnectBlobProvider.FILE_1_BYTES);
        }
        throw new IOException(key);
    }
}

