/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.core;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.liveconnect.LiveConnectFeature;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFile;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.core.MockLiveConnectBlobProvider;
import org.nuxeo.ecm.liveconnect.core.MockLiveConnectFile;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.ConsoleLogLevelThreshold;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogCaptureFeature;
import org.nuxeo.runtime.test.runner.LogFeature;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={LiveConnectFeature.class, LogFeature.class, LogCaptureFeature.class})
@Deploys(value={@Deploy(value={"org.nuxeo.ecm.liveconnect.test:OSGI-INF/test-core-cache-config.xml"}), @Deploy(value={"org.nuxeo.ecm.liveconnect.test:OSGI-INF/test-core-config.xml"}), @Deploy(value={"org.nuxeo.ecm.liveconnect.test:OSGI-INF/test-core-pageprovider-contrib.xml"})})
public class TestLiveConnectBlobProvider {
    protected static final String FILE_1_ID = "5000948880";
    protected static final int FILE_1_SIZE = 629644;
    protected static final String FILE_1_NAME = "tigers.jpeg";
    protected static final String FILE_1_DIGEST = UUID.randomUUID().toString();
    protected static final byte[] FILE_1_BYTES = "picture of a tiger".getBytes(StandardCharsets.UTF_8);
    public static final String INVALID_FILE_ID = "invalid-file-id";
    private static final String TEST_WORKSPACE = "testWorkspace";
    private static final String TEST_FILE_NAME = "LiveConnectFile";
    @Inject
    private CoreSession session;
    @Inject
    private WorkManager workManager;
    @Inject
    private BlobManager blobManager;
    @Inject
    protected LogCaptureFeature.Result logCaptureResult;
    private MockLiveConnectBlobProvider blobProvider;

    @Before
    public void before() {
        this.blobProvider = (MockLiveConnectBlobProvider)this.blobManager.getBlobProvider("core");
        Assert.assertNotNull((Object)((Object)this.blobProvider));
    }

    @After
    public void after() {
        ((CacheService)Framework.getService(CacheService.class)).getCache("core").invalidateAll();
    }

    @Test
    public void testSupportsUserUpdate() {
        Assert.assertTrue((boolean)this.blobProvider.supportsUserUpdate());
        Assert.assertTrue((boolean)this.blobProvider.supportsSync());
    }

    @Test
    public void testReadBlob() throws Exception {
        byte[] bytes;
        BlobInfo blobInfo = LiveConnectFeature.createBlobInfo("core", FILE_1_ID);
        Blob blob = this.blobProvider.readBlob(blobInfo);
        Assert.assertTrue((boolean)(blob instanceof SimpleManagedBlob));
        Assert.assertEquals((Object)blobInfo.key, (Object)((SimpleManagedBlob)blob).getKey());
        Assert.assertEquals((Object)FILE_1_NAME, (Object)blob.getFilename());
        Assert.assertEquals((Object)"image/jpeg", (Object)blob.getMimeType());
        Assert.assertNull((Object)blob.getEncoding());
        Assert.assertEquals((long)629644L, (long)blob.getLength());
        try (InputStream is = blob.getStream();){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        Assert.assertArrayEquals((byte[])FILE_1_BYTES, (byte[])bytes);
    }

    @Test
    @LogCaptureFeature.FilterOn(logLevel="ERROR")
    @ConsoleLogLevelThreshold(value="FATAL")
    public void testReadBrokenBlob() throws Exception {
        byte[] bytes;
        BlobInfo blobInfo = LiveConnectFeature.createBlobInfo("core", INVALID_FILE_ID);
        Blob blob = this.blobProvider.readBlob(blobInfo);
        List caughtEvents = this.logCaptureResult.getCaughtEventMessages();
        Assert.assertEquals((long)1L, (long)caughtEvents.size());
        Assert.assertEquals((Object)"Failed to access file: LiveConnectFileInfo{user=tester@example.com, fileId=invalid-file-id}", caughtEvents.get(0));
        this.logCaptureResult.clear();
        Assert.assertTrue((boolean)(blob instanceof SimpleManagedBlob));
        Assert.assertEquals((Object)blobInfo.key, (Object)((SimpleManagedBlob)blob).getKey());
        Assert.assertEquals((Object)"error.bin", (Object)blob.getFilename());
        Assert.assertEquals((Object)"application/error", (Object)blob.getMimeType());
        Assert.assertNull((Object)blob.getEncoding());
        Assert.assertEquals((long)0L, (long)blob.getLength());
        try (InputStream is = blob.getStream();){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        Assert.assertEquals((long)0L, (long)bytes.length);
        caughtEvents = this.logCaptureResult.getCaughtEventMessages();
        Assert.assertEquals((long)1L, (long)caughtEvents.size());
        Assert.assertEquals((Object)"Failed to access file: core:tester@example.com:invalid-file-id", caughtEvents.get(0));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testWriteBlob() throws Exception {
        this.blobProvider.writeBlob((Blob)LiveConnectFeature.createBlob("core", FILE_1_ID));
    }

    @Test
    public void testCheckChangesAndUpdateBlobWithUpdate() {
        DocumentModel doc = this.session.createDocumentModel("parent", "file-1", "File");
        doc.setPropertyValue("content", (Serializable)LiveConnectFeature.createBlob("core", FILE_1_ID, ""));
        List docs = this.blobProvider.checkChangesAndUpdateBlob(Collections.singletonList(doc));
        Assert.assertFalse((boolean)docs.isEmpty());
        doc = this.session.createDocumentModel("parent", "file-1", "File");
        doc.setPropertyValue("content", (Serializable)LiveConnectFeature.createBlob("core", FILE_1_ID));
        docs = this.blobProvider.checkChangesAndUpdateBlob(Collections.singletonList(doc));
        Assert.assertFalse((boolean)docs.isEmpty());
    }

    @Test
    public void testCheckChangesAndUpdateBlobWithoutUpdate() {
        DocumentModel doc = this.session.createDocumentModel("parent", "file-1", "File");
        List docs = this.blobProvider.checkChangesAndUpdateBlob(Collections.singletonList(doc));
        Assert.assertTrue((boolean)docs.isEmpty());
        doc = this.session.createDocumentModel("parent", "file-1", "File");
        doc.setPropertyValue("content", (Serializable)LiveConnectFeature.createBlob("core", FILE_1_ID, FILE_1_DIGEST));
        docs = this.blobProvider.checkChangesAndUpdateBlob(Collections.singletonList(doc));
        Assert.assertTrue((boolean)docs.isEmpty());
        doc = this.session.createDocumentModel("parent", "file-1", "File");
        doc.setPropertyValue("content", (Serializable)LiveConnectFeature.createBlob("core", FILE_1_ID, FILE_1_DIGEST, UUID.randomUUID().toString()));
        docs = this.blobProvider.checkChangesAndUpdateBlob(Collections.singletonList(doc));
        Assert.assertTrue((boolean)docs.isEmpty());
    }

    @Test
    public void testDocumentUpdate() throws Exception {
        String initialDigest = UUID.randomUUID().toString();
        DocumentModel testWorkspace = this.session.createDocumentModel("/", TEST_WORKSPACE, "Workspace");
        this.session.createDocument(testWorkspace);
        List testFiles = LongStream.range(0L, 60L).mapToObj(i -> this.createDocumentWithBlob(i, initialDigest)).collect(Collectors.toList());
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        this.blobProvider.processDocumentsUpdate();
        this.awaitWorks();
        for (DocumentModel testFile : testFiles) {
            testFile = this.session.getDocument(testFile.getRef());
            SimpleManagedBlob blob = (SimpleManagedBlob)testFile.getPropertyValue("file:content");
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)blob.getDigest()));
            Assert.assertNotEquals((Object)initialDigest, (Object)blob.getDigest());
        }
    }

    @Test
    public void testGetOAuth2Provider() {
        OAuth2ServiceProvider oAuth2Provider = this.blobProvider.getOAuth2Provider();
        Assert.assertNotNull((Object)oAuth2Provider);
    }

    @Test
    public void testToBlobWithFile() {
        MockLiveConnectFile file = new MockLiveConnectFile(new LiveConnectFileInfo("tester@example.com", FILE_1_ID), FILE_1_NAME, 629644L, FILE_1_DIGEST);
        SimpleManagedBlob blob = this.blobProvider.toBlob((LiveConnectFile)file);
        Assert.assertEquals((Object)"core:tester@example.com:5000948880", (Object)blob.getKey());
        Assert.assertEquals((Object)FILE_1_NAME, (Object)blob.getFilename());
        Assert.assertEquals((long)629644L, (long)blob.getLength());
        Assert.assertEquals((Object)FILE_1_DIGEST, (Object)blob.getDigest());
    }

    @Test
    public void testToBlobWithFileWithRevision() {
        String revision = UUID.randomUUID().toString();
        MockLiveConnectFile file = new MockLiveConnectFile(new LiveConnectFileInfo("tester@example.com", FILE_1_ID, revision), FILE_1_NAME, 629644L, FILE_1_DIGEST);
        SimpleManagedBlob blob = this.blobProvider.toBlob((LiveConnectFile)file);
        Assert.assertEquals((Object)("core:tester@example.com:5000948880:" + revision), (Object)blob.getKey());
        Assert.assertEquals((Object)FILE_1_NAME, (Object)blob.getFilename());
        Assert.assertEquals((long)629644L, (long)blob.getLength());
        Assert.assertEquals((Object)FILE_1_DIGEST, (Object)blob.getDigest());
    }

    @Test
    public void testToBlobWithFileInfo() throws Exception {
        LiveConnectFileInfo fileInfo = new LiveConnectFileInfo("tester@example.com", FILE_1_ID);
        SimpleManagedBlob blob = this.blobProvider.toBlob(fileInfo);
        Assert.assertEquals((Object)"core:tester@example.com:5000948880", (Object)blob.getKey());
        Assert.assertEquals((Object)FILE_1_NAME, (Object)blob.getFilename());
        Assert.assertEquals((long)629644L, (long)blob.getLength());
        Assert.assertEquals((Object)FILE_1_DIGEST, (Object)blob.getDigest());
    }

    @Test
    public void testToFileInfo() {
        SimpleManagedBlob blob = LiveConnectFeature.createBlob("core", FILE_1_ID);
        LiveConnectFileInfo fileInfo = this.blobProvider.toFileInfo((ManagedBlob)blob);
        Assert.assertEquals((Object)"tester@example.com", (Object)fileInfo.getUser());
        Assert.assertEquals((Object)FILE_1_ID, (Object)fileInfo.getFileId());
        Assert.assertFalse((boolean)fileInfo.getRevisionId().isPresent());
    }

    @Test
    public void testToFileInfoWithRevision() {
        String revision = UUID.randomUUID().toString();
        BlobInfo blobInfo = LiveConnectFeature.createBlobInfo("core", FILE_1_ID, FILE_1_DIGEST, revision);
        LiveConnectFileInfo fileInfo = this.blobProvider.toFileInfo((ManagedBlob)new SimpleManagedBlob(blobInfo));
        Assert.assertEquals((Object)"tester@example.com", (Object)fileInfo.getUser());
        Assert.assertEquals((Object)FILE_1_ID, (Object)fileInfo.getFileId());
        Assert.assertTrue((boolean)fileInfo.getRevisionId().isPresent());
        Assert.assertEquals((Object)revision, fileInfo.getRevisionId().get());
    }

    @Test
    public void testFileCache() {
        String id = UUID.randomUUID().toString();
        LiveConnectFileInfo fileInfo = new LiveConnectFileInfo("tester@example.com", id);
        Object file = this.blobProvider.getFileFromCache(fileInfo);
        Assert.assertNull((Object)file);
        file = new MockLiveConnectFile(fileInfo, FILE_1_NAME, 629644L, FILE_1_DIGEST);
        this.blobProvider.putFileInCache((LiveConnectFile)file);
        file = this.blobProvider.getFileFromCache(fileInfo);
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)id, (Object)file.getInfo().getFileId());
        Assert.assertEquals((Object)FILE_1_NAME, (Object)file.getFilename());
    }

    @Test
    public void testAsUriError() {
        URI uri = this.blobProvider.asURI("http://");
        Assert.assertNull((Object)uri);
    }

    @Test
    public void testAsUriValid() {
        URI uri = this.blobProvider.asURI("http://www.nuxeo.com/");
        Assert.assertNotNull((Object)uri);
    }

    private DocumentModel createDocumentWithBlob(long id, String digest) {
        DocumentModel testFile = this.session.createDocumentModel("/testWorkspace", TEST_FILE_NAME + id, "File");
        testFile.setPropertyValue("file:content", (Serializable)LiveConnectFeature.createBlob("core", FILE_1_ID, digest));
        return this.session.createDocument(testFile);
    }

    private void awaitWorks() throws InterruptedException {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        boolean allCompleted = this.workManager.awaitCompletion("blobProviderDocumentUpdate", 20L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)allCompleted);
    }
}

