/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import com.google.api.services.drive.model.App;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.liveconnect.core.LiveConnectFileInfo;
import org.nuxeo.ecm.liveconnect.google.drive.GoogleDriveBlobProvider;

public class MockGoogleDriveBlobProvider
extends GoogleDriveBlobProvider {
    public static final String APP_FMT = "/data/googledrive/app-%s.json";
    public static final String FILE_FMT = "/data/googledrive/file-%s.json";
    public static final String DOWNLOAD_FMT = "/data/googledrive/download-%s.bin";
    public static final String REV_FMT = "/data/googledrive/revision-%s-%s.json";
    public static final String REVS_FMT = "/data/googledrive/revisions-%s.json";
    public static final Pattern DOWNLOAD_PAT = Pattern.compile("http://example.com/download/(.*)");

    protected App getApp(String user, String appId) throws IOException {
        return this.getData(String.format(APP_FMT, appId), App.class);
    }

    protected File getPartialFile(String user, String fileId, String ... fields) throws IOException {
        return this.getDriveFile(new LiveConnectFileInfo(user, fileId, null));
    }

    protected File getDriveFile(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getData(String.format(FILE_FMT, fileInfo.getFileId()), File.class);
    }

    protected Revision getRevision(LiveConnectFileInfo fileInfo) throws IOException {
        if (fileInfo.getRevisionId().isEmpty()) {
            throw new NullPointerException("null revisionId for " + fileInfo.getFileId());
        }
        return this.getData(String.format(REV_FMT, fileInfo.getFileId(), fileInfo.getRevisionId().get()), Revision.class);
    }

    protected RevisionList getRevisionList(LiveConnectFileInfo fileInfo) throws IOException {
        return this.getData(String.format(REVS_FMT, fileInfo.getFileId()), RevisionList.class);
    }

    protected InputStream doGet(LiveConnectFileInfo fileInfo, URI uri) {
        Matcher m = DOWNLOAD_PAT.matcher(uri.toString());
        if (m.matches()) {
            String fileId = m.group(1);
            String name = String.format(DOWNLOAD_FMT, fileId);
            return ((Object)((Object)this)).getClass().getResourceAsStream(name);
        }
        throw new UnsupportedOperationException(uri.toString());
    }

    protected String getServiceUser(String username) {
        return username + "@example.com";
    }

    private <T> T getData(String name, Class<T> klass) throws IOException {
        String json;
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);){
            if (is == null) {
                T t = null;
                return t;
            }
            json = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        return (T)JSON_PARSER.parseAndClose((Reader)new StringReader(json), klass);
    }
}

