/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.liveconnect.google.drive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.liveconnect.LiveConnectFeature;
import org.nuxeo.ecm.liveconnect.update.BatchUpdateBlobProvider;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={LiveConnectFeature.class})
public class TestGoogleDriveDocumentUpdate {
    protected static final String TEST_FILE_NAME = "GoogleDriveFile";
    protected static final String JPEG_FILE_ID = "12341234";
    protected static final String JPEG_REVID = "v1abcd";
    protected static final int JPEG_SIZE = 36830;
    protected static final int JPEG_REV_SIZE = 18581;
    protected static final String GOOGLEDOC_FILEID = "56785678";
    protected static final String GOOGLEDOC_REVID = "4551";
    @Inject
    protected CoreSession session;
    @Inject
    protected WorkManager workManager;
    @Inject
    protected BlobManager blobManager;

    @Test
    public void testDocumentUpdate() throws Exception {
        DocumentModel testWorkspace = this.session.createDocumentModel("/", "testWorkspace", "Workspace");
        testWorkspace = this.session.createDocument(testWorkspace);
        ArrayList<DocumentModel> testFiles = new ArrayList<DocumentModel>();
        int i = 0;
        while ((long)i < 60L) {
            DocumentModel testFile = this.session.createDocumentModel("/testWorkspace", TEST_FILE_NAME + i, "File");
            SimpleManagedBlob blob = LiveConnectFeature.createBlob("googledrive", JPEG_FILE_ID);
            testFile.setPropertyValue("content", (Serializable)blob);
            testFile = this.session.createDocument(testFile);
            testFiles.add(testFile);
            ++i;
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        BatchUpdateBlobProvider provider = (BatchUpdateBlobProvider)this.blobManager.getBlobProvider("googledrive");
        provider.processDocumentsUpdate();
        this.awaitWorks();
        for (DocumentModel testFile : testFiles) {
            testFile = this.session.getDocument(testFile.getRef());
            SimpleManagedBlob blob = (SimpleManagedBlob)testFile.getPropertyValue("content");
            Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)blob.getDigest()));
            Assert.assertNotEquals((Object)"pouet", (Object)blob.getDigest());
            Assert.assertEquals((Object)"testimage.jpg", (Object)blob.getFilename());
        }
    }

    protected void awaitWorks() throws InterruptedException {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        boolean allCompleted = this.workManager.awaitCompletion("blobProviderDocumentUpdate", 20000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)allCompleted);
    }
}

