/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.impl.AuditChangeFinder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class ESAuditChangeFinder
extends AuditChangeFinder {
    private static final Logger log = LogManager.getLogger(ESAuditChangeFinder.class);
    protected static final String EVENT_ID = "eventId";

    protected List<LogEntry> queryESAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, int limit) {
        SearchRequest request = new SearchRequest(new String[]{this.getESIndexName()}).types(new String[]{"entry"}).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        QueryBuilder filterBuilder = this.buildFilterClauses(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter(filterBuilder));
        source.sort("repositoryId", SortOrder.ASC).sort("eventDate", SortOrder.DESC);
        source.size(limit);
        request.source(source);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        this.logSearchRequest(request);
        SearchResponse searchResponse = this.getClient().search(request);
        this.logSearchResponse(searchResponse);
        ObjectMapper mapper = new ObjectMapper();
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add((LogEntry)mapper.readValue(hit.getSourceAsString(), LogEntryImpl.class));
            }
            catch (IOException e) {
                log.error("Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    protected QueryBuilder buildFilterClauses(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound) {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        TermQueryBuilder repositoryClauseFilter = QueryBuilders.termQuery((String)"repositoryId", (String)session.getRepositoryName());
        filterBuilder.must((QueryBuilder)repositoryClauseFilter);
        if (activeRoots.getPaths().isEmpty()) {
            filterBuilder.must((QueryBuilder)this.getDriveLogsQueryClause());
        } else {
            BoolQueryBuilder orFilterBuilderIfActiveRoots = QueryBuilders.boolQuery();
            String[] eventIds = new String[]{"documentCreated", "documentModified", "documentMoved", "documentCreatedByCopy", "documentRestored", "addedToCollection", "documentProxyPublished", "documentLocked", "documentUnlocked", "documentUntrashed"};
            BoolQueryBuilder orEventsFilter = QueryBuilders.boolQuery();
            orEventsFilter.should((QueryBuilder)this.getEventsClause("eventDocumentCategory", eventIds, true));
            orEventsFilter.should((QueryBuilder)this.getEventsClause("eventLifeCycleCategory", new String[]{"lifecycle_transition_event"}, true));
            orEventsFilter.should((QueryBuilder)this.getEventsClause("eventLifeCycleCategory", new String[]{"deleted"}, false));
            if (collectionSyncRootMemberIds != null && !collectionSyncRootMemberIds.isEmpty()) {
                BoolQueryBuilder rootsOrCollectionsFilter = QueryBuilders.boolQuery();
                rootsOrCollectionsFilter.should((QueryBuilder)this.getCurrentRootsClause(activeRoots.getPaths()));
                rootsOrCollectionsFilter.should((QueryBuilder)this.getCollectionSyncRootClause(collectionSyncRootMemberIds));
                orFilterBuilderIfActiveRoots.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orEventsFilter).must((QueryBuilder)rootsOrCollectionsFilter));
            } else {
                orFilterBuilderIfActiveRoots.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orEventsFilter).must((QueryBuilder)this.getCurrentRootsClause(activeRoots.getPaths())));
            }
            orFilterBuilderIfActiveRoots.should((QueryBuilder)this.getDriveLogsQueryClause());
            filterBuilder.must((QueryBuilder)orFilterBuilderIfActiveRoots);
        }
        filterBuilder.must((QueryBuilder)this.getLogIdBoundsClause(lowerBound, upperBound));
        return filterBuilder;
    }

    protected RangeQueryBuilder getLogIdBoundsClause(long lowerBound, long upperBound) {
        RangeQueryBuilder rangeFilter = QueryBuilders.rangeQuery((String)"id");
        rangeFilter.gt((Object)lowerBound);
        rangeFilter.lte((Object)upperBound);
        return rangeFilter;
    }

    protected TermsQueryBuilder getCollectionSyncRootClause(Set<String> collectionSyncRootMemberIds) {
        return QueryBuilders.termsQuery((String)"docUUID", collectionSyncRootMemberIds);
    }

    protected BoolQueryBuilder getCurrentRootsClause(Set<String> rootPaths) {
        BoolQueryBuilder orFilterRoots = QueryBuilders.boolQuery();
        for (String rootPath : rootPaths) {
            orFilterRoots.should((QueryBuilder)QueryBuilders.prefixQuery((String)"docPath", (String)rootPath));
        }
        return orFilterRoots;
    }

    protected BoolQueryBuilder getDriveLogsQueryClause() {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"category", (String)"NuxeoDrive"));
        filterBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)EVENT_ID, (String)"rootUnregistered"));
        return filterBuilder;
    }

    protected BoolQueryBuilder getEventsClause(String category, String[] eventIds, boolean shouldMatch) {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"category", (String)category));
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                if (shouldMatch) {
                    filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)EVENT_ID, (String)eventIds[0]));
                } else {
                    filterBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)EVENT_ID, (String)eventIds[0]));
                }
            } else if (shouldMatch) {
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)EVENT_ID, (String[])eventIds));
            } else {
                filterBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)EVENT_ID, (String[])eventIds));
            }
        }
        return filterBuilder;
    }

    public long getUpperBound() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        return this.getUpperBound(new HashSet<String>(repositoryManager.getRepositoryNames()));
    }

    public long getUpperBound(Set<String> repositoryNames) {
        SearchRequest request = new SearchRequest(new String[]{this.getESIndexName()}).types(new String[]{"entry"}).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        RangeQueryBuilder filterBuilder = QueryBuilders.rangeQuery((String)"logDate");
        long clusteringDelay = this.getClusteringDelay(repositoryNames);
        if (clusteringDelay > -1L) {
            long lastClusteringInvalidationDate = System.currentTimeMillis() - 2L * clusteringDelay;
            filterBuilder = filterBuilder.lt((Object)lastClusteringInvalidationDate);
        }
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.sort("id", SortOrder.DESC).size(1);
        ESClient esClient = this.getClient();
        for (int i = 1; i <= 32; i *= 2) {
            ZonedDateTime lowerLogDateTime = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).minusDays(i);
            filterBuilder = filterBuilder.gt((Object)lowerLogDateTime.toInstant().toEpochMilli());
            source.query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)filterBuilder));
            request.source(source);
            this.logSearchRequest(request);
            SearchResponse searchResponse = esClient.search(request);
            this.logSearchResponse(searchResponse);
            ObjectMapper mapper = new ObjectMapper();
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                try {
                    return ((LogEntryImpl)mapper.readValue(hit.getSourceAsString(), LogEntryImpl.class)).getId();
                }
                catch (IOException e) {
                    log.error("Error while reading Audit Entry from ES", (Throwable)e);
                }
            }
        }
        if (clusteringDelay > -1L) {
            source.query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0);
            request.source(source);
            this.logSearchRequest(request);
            SearchResponse searchResponse = esClient.search(request);
            this.logSearchResponse(searchResponse);
            if (searchResponse.getHits().getTotalHits() > 0L) {
                log.debug("Found no audit log entries matching the criterias but some exist, returning 0");
                return 0L;
            }
        }
        log.debug("Found no audit log entries, returning -1");
        return -1L;
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, int limit) {
        List<LogEntry> entries = this.queryESAuditEntries(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            log.debug("Change detected: {}", (Object)entry);
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected ESClient getClient() {
        return ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).getClient();
    }

    protected String getESIndexName() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getIndexNameForType("entry");
    }

    protected void logSearchRequest(SearchRequest request) {
        log.debug("Elasticsearch search request: curl -XGET 'http://localhost:9200/{}/{}/_search?pretty' -d '{}'", new Supplier[]{this::getESIndexName, () -> "entry", () -> request});
    }

    protected void logSearchResponse(SearchResponse response) {
        log.debug("Elasticsearch search response: {}", (Object)response);
    }
}

