/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.excel;

import org.apache.poi.ss.usermodel.Cell;
import org.nuxeo.ecm.platform.groups.audit.service.acl.excel.ExcelBuilder;

public class ExcelBuilderMultiSheet
extends ExcelBuilder {
    protected boolean multiSheetMode = false;

    public ExcelBuilderMultiSheet() {
    }

    public ExcelBuilderMultiSheet(ExcelBuilder.Type type, String firstSheet) {
        super(type, firstSheet);
    }

    public ExcelBuilderMultiSheet(ExcelBuilder.Type type) {
        super(type);
    }

    public boolean isMultiSheetColumns() {
        return this.multiSheetMode;
    }

    public void setMultiSheetColumns(boolean multiSheetMode) {
        this.multiSheetMode = multiSheetMode;
    }

    @Override
    protected Cell getOrCreateCell(int i, int j) {
        if (this.multiSheetMode) {
            j = this.autoSelectSheet(j);
        }
        return super.getOrCreateCell(i, j);
    }

    @Override
    protected boolean validateCellIndex(int row, int column, String content) {
        if (this.multiSheetMode) {
            if (row >= MAX_ROW) {
                String message = "max number of row (" + MAX_ROW + ") exceeded @ " + row + " by '" + content + "'";
                log.warn((Object)message);
                return false;
            }
            return true;
        }
        return super.validateCellIndex(row, column, content);
    }

    public int getVirtualCellSheet(int realColumn) {
        return realColumn / 256;
    }

    public int getVirtualCellColumn(int realColumn) {
        return realColumn % 256;
    }

    protected int autoSelectSheet(int column) {
        int s = this.getVirtualCellSheet(column);
        if (s != this.getCurrentSheetId()) {
            if (!this.sheetInitialized(s)) {
                this.setCurrentSheetId(this.newSheet(s, "(" + s + ")"));
            } else {
                this.setCurrentSheetId(s);
            }
        }
        column = this.getVirtualCellColumn(column);
        return column;
    }
}

