/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mail;

import com.dumbster.smtp.SimpleSmtpServer;
import com.dumbster.smtp.SmtpMessage;
import com.google.inject.Binder;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.mail.MailSessionBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@Deploy(value={"org.nuxeo.runtime.jtajca"})
@Features(value={RuntimeFeature.class})
public class SmtpMailServerFeature
implements RunnerFeature {
    private static final Logger log = LogManager.getLogger(SmtpMailServerFeature.class);
    protected static final String SERVER_HOST = "127.0.0.1";
    protected static final String DEFAULT_MAIL_SENDER = "noreply@nuxeo.com";
    protected static final Pattern MAIL_DATE_PATTERN = Pattern.compile("(.*)\\s(\\(\\w*\\))$");
    protected SimpleSmtpServer server;
    protected MailsResult result = new MailsResult();
    protected Map<String, Object> backupProperties;

    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(MailsResult.class).toInstance((Object)this.result);
    }

    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        this.start();
    }

    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        this.stop();
    }

    protected void start() {
        try {
            this.server = SimpleSmtpServer.start((int)0);
            this.result.skip = 0;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        int serverPort = this.server.getPort();
        log.debug("Fake smtp server started on port: {}", (Object)serverPort);
        Properties frameworkProperties = Framework.getProperties();
        this.backupProperties = frameworkProperties.stringPropertyNames().stream().filter(k -> k.startsWith("mail.")).collect(Collectors.toMap(Function.identity(), frameworkProperties::get));
        Properties properties = new Properties();
        properties.putAll(this.backupProperties);
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", SERVER_HOST);
        properties.put("mail.smtp.port", String.valueOf(serverPort));
        properties.putIfAbsent("mail.smtp.from", DEFAULT_MAIL_SENDER);
        properties.putIfAbsent("mail.from", DEFAULT_MAIL_SENDER);
        this.binding(properties);
        frameworkProperties.put("mail.transport.protocol", "smtp");
        frameworkProperties.put("mail.transport.host", SERVER_HOST);
        frameworkProperties.put("mail.transport.port", String.valueOf(serverPort));
    }

    protected void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        this.unbind();
        this.clear();
    }

    protected void binding(Properties properties) {
        try {
            Context context = NuxeoContainer.getRootContext();
            context.bind("java:comp/env/Mail", (Object)MailSessionBuilder.fromProperties((Properties)properties).build());
        }
        catch (NamingException ne) {
            throw new NuxeoException("Unable to bind the SMTP server in jndi", (Throwable)ne);
        }
    }

    protected void unbind() {
        try {
            Context context = NuxeoContainer.getRootContext();
            context.unbind("java:comp/env/Mail");
        }
        catch (NameNotFoundException nnf) {
            log.trace("{} is not found", (Object)"java:comp/env/Mail", (Object)nnf);
        }
        catch (NamingException ne) {
            throw new NuxeoException("Unable to unbind the SMTP server in jndi", (Throwable)ne);
        }
    }

    protected void clear() {
        Properties frameworkProperties = Framework.getProperties();
        frameworkProperties.remove("mail.transport.protocol");
        frameworkProperties.remove("mail.transport.host");
        frameworkProperties.remove("mail.transport.port");
        frameworkProperties.putAll(this.backupProperties);
    }

    public static class MailMessage {
        protected String id;
        protected List<String> senders;
        protected List<String> recipients;
        protected String subject;
        protected String content;
        protected ZonedDateTime date;
        protected String contentType;

        public MailMessage(String id, List<String> senders, List<String> recipients, String subject, String contentType, String content, ZonedDateTime date) {
            this.id = Objects.requireNonNull(id);
            this.senders = Objects.requireNonNullElseGet(senders, List::of);
            this.recipients = Objects.requireNonNullElseGet(recipients, List::of);
            this.subject = subject;
            this.contentType = contentType;
            this.content = content;
            this.date = date;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getSenders() {
            return this.senders;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getContent() {
            return this.content;
        }

        public ZonedDateTime getDate() {
            return this.date;
        }

        public String getContentType() {
            return this.contentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MailMessage that = (MailMessage)o;
            return new EqualsBuilder().append((Object)this.id, (Object)that.id).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
        }
    }

    public class MailsResult {
        protected int skip = 0;

        public Stream<MailMessage> streamMails() {
            if (Objects.isNull(SmtpMailServerFeature.this.server)) {
                log.trace("No server available");
                return Stream.empty();
            }
            return SmtpMailServerFeature.this.server.getReceivedEmails().stream().map(this::convert).skip(this.skip);
        }

        public List<MailMessage> getMails() {
            return this.streamMails().collect(Collectors.toList());
        }

        public void clearMails() {
            if (Objects.isNull(SmtpMailServerFeature.this.server)) {
                log.trace("No server available");
                return;
            }
            this.skip = SmtpMailServerFeature.this.server.getReceivedEmails().size();
        }

        public List<MailMessage> getMailsBySubject(String subject) {
            return this.streamMails().filter(e -> subject.equals(e.getSubject())).collect(Collectors.toList());
        }

        public boolean hasSubject(String subject) {
            return this.streamMails().anyMatch(e -> subject.equals(e.getSubject()));
        }

        public void assertSender(String sender, int expectedMailsCount) {
            Assert.assertEquals((long)expectedMailsCount, (long)this.getMailsBySender(sender).size());
        }

        public void assertRecipient(String recipient, int expectedMailsCount) {
            Assert.assertEquals((long)expectedMailsCount, (long)this.getMailsByRecipient(recipient).size());
        }

        public List<MailMessage> getMailsBySender(String from) {
            return this.streamMails().filter(e -> e.getSenders().contains(from)).collect(Collectors.toList());
        }

        public List<MailMessage> getMailsByRecipient(String recipient) {
            return this.streamMails().filter(e -> e.getRecipients().contains(recipient)).collect(Collectors.toList());
        }

        public int getSize() {
            return (int)this.streamMails().count();
        }

        protected MailMessage convert(SmtpMessage sm) {
            ZonedDateTime date = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sm.getHeaderValue("Date")})) {
                String dateAsText = sm.getHeaderValue("Date");
                Matcher matcher = MAIL_DATE_PATTERN.matcher(dateAsText);
                if (matcher.matches()) {
                    dateAsText = matcher.group(1);
                }
                date = ZonedDateTime.parse(dateAsText, DateTimeFormatter.RFC_1123_DATE_TIME);
            }
            return new MailMessage(sm.getHeaderValue("Message-ID"), sm.getHeaderValues("From"), sm.getHeaderValues("To"), sm.getHeaderValue("Subject"), sm.getHeaderValue("Content-Type"), sm.getBody(), date);
        }
    }
}

