/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.management;

import java.io.Serializable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="management/thumbnails")
@Produces(value={"application/json"})
public class ThumbnailsObject
extends AbstractResource<ResourceTypeImpl> {
    public static final String THUMBNAILS_DEFAULT_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Thumbnail' AND thumb:thumbnail/data IS NULL AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:isTrashed = 0";

    @POST
    @Path(value="recompute")
    public BulkStatus doPostThumbnails(@FormParam(value="query") String query) {
        String finalQuery = (String)StringUtils.defaultIfBlank((CharSequence)query, (CharSequence)THUMBNAILS_DEFAULT_QUERY);
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        String commandId = bulkService.submit(new BulkCommand.Builder("recomputeThumbnails", finalQuery, "system").repository(this.ctx.getCoreSession().getRepositoryName()).build());
        return (BulkStatus)bulkService.getStatus((Serializable)((Object)commandId));
    }
}

