/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.operation;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.runtime.api.Framework;

@Operation(id="RecomputeThumbnails", category="Services", label="Recompute Thumbnails", description="Recompute the thumbnail of the documents resulting from the provided NXQL query.", since="10.10")
public class RecomputeThumbnails {
    protected static final String THUMBNAIL_XPATH = "thumb:thumbnail/data";
    public static final String ID = "RecomputeThumbnails";
    public static final String DEFAULT_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Thumbnail' AND thumb:thumbnail/data IS NULL AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:isTrashed = 0";
    @Context
    protected OperationContext ctx;
    @Param(name="query", description="NXQL query to collect the documents whose thumnail to recompute.", values={"SELECT * FROM Document WHERE ecm:mixinType = 'Thumbnail' AND thumb:thumbnail/data IS NULL AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:isTrashed = 0"})
    protected String query;

    @OperationMethod
    public void run() {
        BulkService service = (BulkService)Framework.getService(BulkService.class);
        String username = this.ctx.getPrincipal().getName();
        service.submit(new BulkCommand.Builder("recomputeThumbnails", this.query, username).build());
    }
}

