/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.action;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RecomputeThumbnailsAction
implements StreamProcessorTopology {
    public static final String THUMBNAIL_UPDATED = "thumbnailUpdated";
    public static final String ACTION_NAME = "recomputeThumbnails";
    public static final String ACTION_FULL_NAME = "bulk/recomputeThumbnails";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(RecomputeThumbnailsComputation::new, Arrays.asList("i1:bulk/recomputeThumbnails", "o1:bulk/status")).build();
    }

    public static class RecomputeThumbnailsComputation
    extends AbstractBulkComputation {
        public RecomputeThumbnailsComputation() {
            super(RecomputeThumbnailsAction.ACTION_FULL_NAME);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            DocumentModelList docs = this.loadDocuments(session, ids);
            for (DocumentModel doc : docs) {
                this.processDoc(session, doc);
            }
        }

        protected void processDoc(CoreSession session, DocumentModel doc) {
            Blob thumbnailBlob = this.getManagedThumbnail(doc);
            if (thumbnailBlob == null) {
                ThumbnailAdapter thumbnailAdapter = (ThumbnailAdapter)doc.getAdapter(ThumbnailAdapter.class);
                if (thumbnailAdapter == null) {
                    return;
                }
                thumbnailBlob = thumbnailAdapter.computeThumbnail(session);
            }
            if (thumbnailBlob != null) {
                if (!doc.hasFacet("Thumbnail")) {
                    doc.addFacet("Thumbnail");
                }
                doc.setPropertyValue("thumb:thumbnail", (Serializable)thumbnailBlob);
            } else if (doc.hasFacet("Thumbnail")) {
                doc.setPropertyValue("thumb:thumbnail", null);
                doc.removeFacet("Thumbnail");
            }
            if (doc.isDirty()) {
                doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
                doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
                doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
                doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
                doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
                if (doc.isVersion()) {
                    doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                }
                doc.putContextData(RecomputeThumbnailsAction.THUMBNAIL_UPDATED, (Serializable)Boolean.valueOf(true));
                session.saveDocument(doc);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Blob getManagedThumbnail(DocumentModel doc) {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                return null;
            }
            Blob blob3 = bh.getBlob();
            if (blob3 == null) {
                return null;
            }
            BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
            try (InputStream is = blobManager.getThumbnail(blob3);){
                if (is == null) {
                    Blob blob2 = null;
                    return blob2;
                }
                Blob blob = Blobs.createBlob((InputStream)is);
                return blob;
            }
            catch (IOException e) {
                throw new NuxeoException("Failed to get managed blob thumbnail", (Throwable)e);
            }
        }
    }
}

