/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.action;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.platform.thumbnail.listener.ThumbnailHelper;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RecomputeThumbnailsAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "recomputeThumbnails";
    public static final String ACTION_FULL_NAME = "bulk/recomputeThumbnails";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(RecomputeThumbnailsComputation::new, Arrays.asList("i1:bulk/recomputeThumbnails", "o1:bulk/status")).build();
    }

    public static class RecomputeThumbnailsComputation
    extends AbstractBulkComputation {
        protected ThumbnailHelper thumbnailHelper = new ThumbnailHelper();

        public RecomputeThumbnailsComputation() {
            super(RecomputeThumbnailsAction.ACTION_FULL_NAME);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            DocumentModelList docs = this.loadDocuments(session, ids);
            for (DocumentModel doc : docs) {
                this.thumbnailHelper.newTransaction();
                this.processDoc(session, doc);
            }
        }

        protected void processDoc(CoreSession session, DocumentModel doc) {
            this.thumbnailHelper.createThumbnailIfNeeded(session, doc);
        }
    }
}

