/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.io.TaskCompletionRequest;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.restapi.server.jaxrs.PaginableObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="task")
public class TaskObject
extends PaginableObject<Task> {
    public static final String PAGE_PROVIDER_NAME = "nuxeo_tasks_listing";
    public static final String BASE_QUERY = String.format("SELECT * FROM Document WHERE ecm:mixinType = '%s' AND ecm:currentLifeCycleState = '%s'", "Task", "opened");
    protected String userId;
    protected String workflowInstanceId;
    @Deprecated
    protected String workflowModelName;

    protected void initialize(Object ... args) {
        super.initialize(args);
        HttpServletRequest request = this.ctx.getRequest();
        this.userId = request.getParameter("userId");
        this.workflowInstanceId = request.getParameter("workflowInstanceId");
        this.workflowModelName = request.getParameter("workflowModelName");
    }

    @PUT
    @Path(value="{taskId}/reassign")
    @Consumes
    public Response reassignTask(@PathParam(value="taskId") String taskId, @QueryParam(value="actors") List<String> actors, @QueryParam(value="comment") String comment) {
        ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).reassignTask(this.getContext().getCoreSession(), taskId, actors, comment);
        return Response.ok().status(Response.Status.OK).build();
    }

    @PUT
    @Path(value="{taskId}/delegate")
    public Response delegateTask(@PathParam(value="taskId") String taskId, @QueryParam(value="delegatedActors") List<String> delegatedActors, @QueryParam(value="comment") String comment) {
        ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).delegateTask(this.getContext().getCoreSession(), taskId, delegatedActors, comment);
        return Response.ok().status(Response.Status.OK).build();
    }

    @PUT
    @Path(value="{taskId}/{taskAction}")
    public Response completeTask(@PathParam(value="taskId") String taskId, @PathParam(value="taskAction") String action, TaskCompletionRequest taskCompletionRequest) {
        Map data = taskCompletionRequest.getDataMap();
        CoreSession session = this.getContext().getCoreSession();
        ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).endTask(session, (Task)session.getDocument((DocumentRef)new IdRef(taskId)).getAdapter(Task.class), data, action);
        Task completedTask = (Task)session.getDocument((DocumentRef)new IdRef(taskId)).getAdapter(Task.class);
        return Response.ok((Object)completedTask).status(Response.Status.OK).build();
    }

    @GET
    public List<Task> getUserRelatedWorkflowTasks() {
        if (StringUtils.isNotBlank((CharSequence)this.workflowModelName)) {
            return ((DocumentRoutingService)Framework.getService(DocumentRoutingService.class)).getTasks(null, this.userId, this.workflowInstanceId, this.workflowModelName, this.getContext().getCoreSession());
        }
        return this.getPaginableEntries();
    }

    @GET
    @Path(value="{taskId}")
    public Task getTaskById(@PathParam(value="taskId") String taskId) {
        DocumentModel docModel = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(taskId));
        return (Task)docModel.getAdapter(Task.class);
    }

    protected PageProviderDefinition getPageProviderDefinition() {
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        return pageProviderService.getPageProviderDefinition(PAGE_PROVIDER_NAME);
    }

    protected Object[] getParams() {
        return new Object[]{this.userId, this.workflowInstanceId};
    }
}

