/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.process;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.nuxeo.launcher.process.UnixProcessManager;

public class SolarisProcessManager
extends UnixProcessManager {
    protected static final String SOLARIS_11 = "5.11";
    protected static final String SOLARIS_10 = "5.10";
    protected static final String[] SOLARIS_11_PS = new String[]{"/usr/bin/ps", "auxww"};
    protected static final String[] SOLARIS_10_PS = new String[]{"/usr/ucb/ps", "auxww"};
    protected static final Pattern PS_OUTPUT_LINE = Pattern.compile("^[^\\s]+\\s+([0-9]+)\\s+[0-9.\\s]+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+(.*)$");
    protected String solarisVersion;

    public String getSolarisVersion() {
        if (this.solarisVersion == null) {
            List<Object> lines;
            try {
                lines = this.execute("/usr/bin/uname", "-r");
            }
            catch (IOException e) {
                lines = Collections.emptyList();
            }
            this.solarisVersion = lines.isEmpty() ? "?" : ((String)lines.get(0)).trim();
        }
        return this.solarisVersion;
    }

    @Override
    protected String[] psCommand() {
        if (SOLARIS_11.equals(this.getSolarisVersion())) {
            return SOLARIS_11_PS;
        }
        return null;
    }

    public Matcher getLineMatcher(String line) {
        return PS_OUTPUT_LINE.matcher(line);
    }

    @Override
    public String findPid(String regex) throws IOException {
        if (SOLARIS_11.equals(this.getSolarisVersion())) {
            Pattern commandPattern = Pattern.compile(regex);
            for (String line : this.execute(this.psCommand())) {
                Matcher lineMatcher = this.getLineMatcher(line);
                if (!lineMatcher.matches()) continue;
                String pid = lineMatcher.group(1);
                String command = lineMatcher.group(2);
                Matcher commandMatcher = commandPattern.matcher(command);
                if (!commandMatcher.find()) continue;
                return pid;
            }
        } else {
            throw new RuntimeException("Unsupported Solaris version: " + this.solarisVersion);
        }
        return null;
    }

    protected List<String> execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).start();
        return IOUtils.readLines(process.getInputStream(), StandardCharsets.UTF_8);
    }
}

