/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.http4.Http4FileObject;
import org.apache.commons.vfs2.provider.http4.Http4FileSystem;
import org.apache.commons.vfs2.provider.http4.MonitoredHttpResponseContentInputStream;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;

class Http4RandomAccessContent<FS extends Http4FileSystem>
extends AbstractRandomAccessStreamContent {
    protected long filePointer = 0L;
    private final Http4FileObject<FS> fileObject;
    private DataInputStream dis = null;
    private MonitorInputStream mis = null;

    Http4RandomAccessContent(Http4FileObject<FS> fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", (Object)pos);
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        long skipped;
        if (this.dis != null) {
            return this.dis;
        }
        HttpGet httpGet = new HttpGet(this.fileObject.getInternalURI());
        httpGet.setHeader("Range", "bytes=" + this.filePointer + "-");
        HttpResponse httpResponse = this.fileObject.executeHttpUriRequest(httpGet);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status != 206 && status != 200) {
            throw new FileSystemException("vfs.provider.http/get-range.error", this.fileObject.getName(), this.filePointer, status);
        }
        this.mis = new MonitoredHttpResponseContentInputStream(httpResponse);
        if (status == 200 && (skipped = this.mis.skip(this.filePointer)) != this.filePointer) {
            throw new FileSystemException("vfs.provider.http/get-range.error", this.fileObject.getName(), this.filePointer, status);
        }
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++Http4RandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    Http4RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    Http4RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }
        });
        return this.dis;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.dis.close();
            this.dis = null;
            this.mis = null;
        }
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

