/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileReader {
    public static final Logger LOG = LoggerFactory.getLogger(CombinedHostsFileReader.class);

    private CombinedHostsFileReader() {
    }

    public static DatanodeAdminProperties[] readFile(String hostsFile) throws IOException {
        DatanodeAdminProperties[] allDNs = new DatanodeAdminProperties[]{};
        ObjectMapper objectMapper = new ObjectMapper();
        boolean tryOldFormat = false;
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
            allDNs = objectMapper.readValue((Reader)input, DatanodeAdminProperties[].class);
        }
        catch (JsonMappingException jme) {
            tryOldFormat = true;
            LOG.warn("{} has invalid JSON format.Try the old format without top-level token defined.", (Object)hostsFile);
        }
        if (tryOldFormat) {
            ObjectReader objectReader = objectMapper.readerFor(DatanodeAdminProperties.class);
            JsonFactory jsonFactory = new JsonFactory();
            ArrayList<DatanodeAdminProperties> all = new ArrayList<DatanodeAdminProperties>();
            try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
                MappingIterator iterator = objectReader.readValues(jsonFactory.createParser(input));
                while (iterator.hasNext()) {
                    DatanodeAdminProperties properties = (DatanodeAdminProperties)iterator.next();
                    all.add(properties);
                }
            }
            allDNs = all.toArray(new DatanodeAdminProperties[all.size()]);
        }
        return allDNs;
    }
}

