/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import hidden.org.eclipse.core.runtime.IStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.cudf.Log;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.metadata.Version;
import org.eclipse.equinox.p2.cudf.query.QueryableArray;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.eclipse.equinox.p2.cudf.solver.ProfileChangeRequest;
import org.eclipse.equinox.p2.cudf.solver.Projector;
import org.eclipse.equinox.p2.cudf.solver.Slicer;
import org.eclipse.equinox.p2.cudf.solver.SolverConfiguration;
import org.sat4j.pb.IPBSolver;

public class SimplePlanner {
    private static final boolean PURGE = true;
    private Projector projector;

    public Object getSolutionFor(ProfileChangeRequest profileChangeRequest, SolverConfiguration configuration) {
        QueryableArray profile = profileChangeRequest.getInitialState();
        InstallableUnit updatedPlan = this.updatePlannerInfo(profileChangeRequest);
        Slicer slice = new Slicer(profile);
        profile = slice.slice(updatedPlan, configuration.objective.equals("p2") ? null : profileChangeRequest.getExtraRequirements());
        Log.println("Number of  packages after slice: " + profile.getSize());
        if (profileChangeRequest.getInitialState().getSize() != 0) {
            Log.println("Slice efficiency: " + (100 - (profile.getSize() - 1) * 100 / profileChangeRequest.getInitialState().getSize()) + "%");
        }
        profileChangeRequest.purge();
        this.projector = new Projector(profile);
        this.projector.encode(updatedPlan, configuration);
        IStatus s = this.projector.invokeSolver();
        if (s.getSeverity() == 4) {
            return s;
        }
        return this.projector.extractSolution();
    }

    private InstallableUnit updatePlannerInfo(ProfileChangeRequest profileChangeRequest) {
        return this.createIURepresentingTheProfile(profileChangeRequest.getAllRequests());
    }

    private InstallableUnit createIURepresentingTheProfile(List<IRequiredCapability> allRequirements) {
        InstallableUnit iud = new InstallableUnit();
        String time = Long.toString(System.currentTimeMillis());
        iud.setId(time);
        iud.setVersion(new Version(0, 0, 0, time));
        iud.setRequiredCapabilities(allRequirements.toArray(new IRequiredCapability[allRequirements.size()]));
        Log.println("Request size: " + iud.getRequiredCapabilities().length);
        return iud;
    }

    public void stopSolver() {
        if (this.projector != null) {
            this.projector.stopSolver();
        }
    }

    public Collection<InstallableUnit> getBestSolutionFoundSoFar() {
        return this.projector.getBestSolutionFoundSoFar();
    }

    public Set<?> getExplanation() {
        return this.projector.getExplanation();
    }

    public IPBSolver getSolver() {
        return this.projector.dependencyHelper.getSolver();
    }

    public Map<Integer, Object> getMappingToDomain() {
        return this.projector.dependencyHelper.getMappingToDomain();
    }

    public boolean isSolutionOptimal() {
        return this.projector.dependencyHelper.isOptimal();
    }

    public Map<OptimizationFunction.Criteria, List<String>> getSolutionDetails() {
        return this.projector.getSolutionDetails();
    }
}

