/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.function;

import java.util.function.Consumer;
import org.nuxeo.common.function.FunctionUtils;

@FunctionalInterface
public interface ThrowableConsumer<T, E extends Throwable> {
    public void accept(T var1) throws E;

    default public Consumer<T> toConsumer() {
        return ThrowableConsumer.asConsumer(this);
    }

    public static <T, E extends Throwable> Consumer<T> asConsumer(ThrowableConsumer<T, E> throwableConsumer) {
        return arg -> {
            try {
                throwableConsumer.accept(arg);
            }
            catch (Throwable t) {
                FunctionUtils.sneakyThrow(t);
            }
        };
    }
}

