/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.Sorter;
import org.nuxeo.common.xmap.XAnnotatedMember;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.w3c.dom.Element;

public class XAnnotatedObject {
    final XMap xmap;
    final Class<?> klass;
    final Constructor<?> ctor;
    final Path path;
    final List<XAnnotatedMember> members;
    Sorter sorter;

    public XAnnotatedObject(XMap xmap, Class<?> klass, XObject xob) {
        try {
            this.xmap = xmap;
            this.klass = klass;
            this.ctor = this.klass.getDeclaredConstructor(new Class[0]);
            this.ctor.setAccessible(true);
            this.path = new Path(xob.value());
            this.members = new ArrayList<XAnnotatedMember>();
            String[] order = xob.order();
            if (order.length > 0) {
                this.sorter = new Sorter(order);
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid xmap class - no default constructor found", e);
        }
    }

    public void addMember(XAnnotatedMember member) {
        this.members.add(member);
    }

    public Path getPath() {
        return this.path;
    }

    public Object newInstance(Context ctx, Element element) {
        Object ob;
        try {
            ob = this.ctor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalArgumentException(e);
        }
        ctx.push(ob);
        if (this.sorter != null) {
            Collections.sort(this.members, this.sorter);
            this.sorter = null;
        }
        for (XAnnotatedMember member : this.members) {
            member.process(ctx, element);
        }
        return ctx.pop();
    }
}

