/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageCacheEntry;

public class PackageListCacheEntry {
    protected List<PackageCacheEntry> pkgEntries = new ArrayList<PackageCacheEntry>();
    protected long ts;

    public PackageListCacheEntry() {
    }

    public PackageListCacheEntry(List<DownloadablePackage> pkgs) {
        if (pkgs != null) {
            for (DownloadablePackage pkg : pkgs) {
                this.pkgEntries.add(new PackageCacheEntry(pkg));
            }
            this.ts = System.currentTimeMillis();
        }
    }

    public List<PackageCacheEntry> getPackageCacheEntries() {
        return this.pkgEntries;
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public List<DownloadablePackage> getPackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (PackageCacheEntry pkgEntry : this.pkgEntries) {
            result.add(pkgEntry.getPackage());
        }
        return result;
    }

    public boolean isExpired(long cacheDurationInMinutes) {
        return System.currentTimeMillis() - this.getTimeStamp() > cacheDurationInMinutes * 60L * 1000L;
    }
}

