/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Version
implements Comparable<Version> {
    private static final Log log = LogFactory.getLog(Version.class);
    public static final String SNAPSHOT = "-SNAPSHOT";
    public static final Version ZERO = new Version(0);
    public static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?");
    public static final Pattern SPECIAL_CLASSIFIER = Pattern.compile("^(((RC|rc|alpha|ALPHA|beta|BETA)\\d*)|([a-zA-Z][0-9]{8})).*$");
    protected boolean specialClassifier = false;
    protected int major;
    protected int minor;
    protected int patch;
    protected String classifier;
    protected boolean snapshot = false;

    public boolean isSpecialClassifier() {
        return this.specialClassifier;
    }

    public Version(String version) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(version);
        if (versionMatcher.find()) {
            String versionClassifier;
            String versionNumber = versionMatcher.group();
            Pattern digitVersion = Pattern.compile("[0-9]+");
            versionMatcher = digitVersion.matcher(versionNumber);
            if (versionMatcher.find()) {
                this.major = Integer.parseInt(versionMatcher.group());
                if (versionMatcher.find()) {
                    this.minor = Integer.parseInt(versionMatcher.group());
                    if (versionMatcher.find()) {
                        this.patch = Integer.parseInt(versionMatcher.group());
                    }
                }
            }
            if ((versionClassifier = version.substring(versionNumber.length())).contains(SNAPSHOT)) {
                this.snapshot = true;
                versionClassifier = versionClassifier.replaceFirst(SNAPSHOT, "");
            }
            if (versionClassifier != null && !versionClassifier.isEmpty()) {
                this.classifier = versionClassifier.substring(1);
                this.specialClassifier = SPECIAL_CLASSIFIER.matcher(this.classifier).matches();
            }
        }
    }

    public Version(int major) {
        this(major, 0, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    public Version(int major, int minor, int patch, String classifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.classifier = classifier;
        if (classifier != null) {
            this.specialClassifier = SPECIAL_CLASSIFIER.matcher(classifier).matches();
        }
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String classifier() {
        return this.classifier;
    }

    public boolean lessThan(Version v) {
        return this.compareTo(v) < 0;
    }

    public boolean lessOrEqualsThan(Version v) {
        return this.compareTo(v) <= 0;
    }

    public boolean equalsTo(Version v) {
        return this.compareTo(v) == 0;
    }

    public boolean greaterThan(Version v) {
        return this.compareTo(v) > 0;
    }

    public boolean greaterOrEqualThan(Version v) {
        return this.compareTo(v) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        String oClassifier;
        log.trace("Comparing " + this + " with " + o);
        int d = this.major - o.major;
        if (d != 0) {
            return d;
        }
        d = this.minor - o.minor;
        if (d != 0) {
            return d;
        }
        d = this.patch - o.patch;
        if (d != 0) {
            return d;
        }
        String mClassifier = this.classifier == null ? "" : this.classifier;
        String string = oClassifier = o.classifier == null ? "" : o.classifier;
        if (mClassifier.equals(oClassifier)) {
            if (this.snapshot == o.isSnapshot()) {
                log.trace(" case 1 => 0");
                return 0;
            }
            if (this.isSnapshot()) {
                log.trace(" case 2 => -1");
                return -1;
            }
            log.trace(" case 3 => 1");
            return 1;
        }
        if (this.specialClassifier && o.isSpecialClassifier() || !this.specialClassifier && !o.isSpecialClassifier()) {
            log.trace(" case 4 => compare classifiers");
            return mClassifier.compareTo(oClassifier);
        }
        if (this.specialClassifier) {
            log.trace(" case 1 => -1");
            return -1;
        }
        log.trace(" case 6 => 1");
        return 1;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof Version && this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        return this.major << 16 | this.minor << 8 | this.patch;
    }

    public String toString() {
        String v = this.major + "." + this.minor + "." + this.patch;
        if (this.classifier != null) {
            v = v + "-" + this.classifier;
        }
        if (this.isSnapshot()) {
            v = v + SNAPSHOT;
        }
        return v;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean isSnapshot) {
        this.snapshot = isSnapshot;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean isUpgradeFor(Version version) {
        return this.isUpgradeFor(version, true);
    }

    public boolean isUpgradeFor(Version version, boolean snapshotUpgrade) {
        return this.greaterThan(version) || snapshotUpgrade && this.isSnapshot() && this.equalsTo(version);
    }
}

