/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.nuxeo.connect.update.PackageData;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.runtime.api.SharedResourceLoader;

public class LocalPackageData
implements PackageData {
    protected File root;
    protected SharedResourceLoader loader;

    public LocalPackageData(ClassLoader parent, File file) throws IOException {
        this.root = file.getCanonicalFile();
        if (parent == null && (parent = Thread.currentThread().getContextClassLoader()) == null) {
            parent = this.getClass().getClassLoader();
        }
        try {
            this.loader = new SharedResourceLoader(new URL[0], parent);
            this.loader.addURL(this.root.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create package class loader. Invalid package root: " + this.root, e);
        }
    }

    public void setRoot(File file) {
        this.root = file;
    }

    @Override
    public ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public File getEntry(String path) {
        return new File(this.root, path);
    }

    @Override
    public InputStream getEntryAsStream(String path) throws IOException {
        return new FileInputStream(this.getEntry(path));
    }

    @Override
    public File getManifest() {
        return this.getEntry("package.xml");
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public Class<?> loadClass(String name) throws PackageException {
        try {
            return this.loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new PackageException("Failed to load class " + name + " from package: " + this.root.getName());
        }
    }
}

