/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.Validator;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.Form;
import org.nuxeo.connect.update.model.TaskDefinition;
import org.nuxeo.connect.update.standalone.LocalPackageData;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.xml.FormsDefinition;
import org.nuxeo.connect.update.xml.PackageDefinitionImpl;
import org.nuxeo.connect.update.xml.TaskDefinitionImpl;

public class LocalPackageImpl
implements LocalPackage {
    protected String id;
    protected PackageState state = PackageState.UNKNOWN;
    protected LocalPackageData data;
    protected PackageDefinitionImpl def;
    private PackageUpdateService service;

    @Deprecated
    public LocalPackageImpl(File file, int state, PackageUpdateService pus) throws PackageException {
        this(null, file, state, pus);
    }

    @Deprecated
    public LocalPackageImpl(ClassLoader parent, File file, int state, PackageUpdateService pus) throws PackageException {
        this(parent, file, PackageState.getByValue(state), pus);
    }

    public LocalPackageImpl(File file, PackageState state, PackageUpdateService pus) throws PackageException {
        this(null, file, state, pus);
    }

    public LocalPackageImpl(ClassLoader parent, File file, PackageState state, PackageUpdateService pus) throws PackageException {
        this.state = state;
        this.service = pus;
        XMap xmap = StandaloneUpdateService.getXmap();
        if (xmap == null) {
            xmap = StandaloneUpdateService.createXmap();
        }
        try {
            this.data = new LocalPackageData(parent, file);
            try (FileInputStream in = new FileInputStream(this.data.getManifest());){
                this.def = (PackageDefinitionImpl)xmap.load(in);
            }
        }
        catch (FileNotFoundException e) {
            throw new PackageException("Invalid package - no package.xml file found in package " + file.getName());
        }
        catch (IOException e) {
            throw new PackageException("Failed to load package.xml descriptor for package " + file.getName(), e);
        }
        this.id = this.def.getId();
    }

    @Override
    @Deprecated
    public void setState(int state) {
        this.state = PackageState.getByValue(state);
    }

    @Override
    public void setState(PackageState state) {
        this.state = state;
    }

    @Override
    public LocalPackageData getData() {
        return this.data;
    }

    @Override
    public File getInstallFile() {
        return this.data.getEntry("install.xml");
    }

    @Override
    public File getUninstallFile() {
        return this.data.getEntry("uninstall.xml");
    }

    @Override
    public String getLicenseType() {
        return this.def.getLicenseType();
    }

    @Override
    public String getLicenseUrl() {
        return this.def.getLicenseUrl();
    }

    @Override
    public String getLicenseContent() throws PackageException {
        File file = this.data.getEntry("license.txt");
        if (file.isFile()) {
            try {
                return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new PackageException("Failed to read license.txt file for package: " + this.getId());
            }
        }
        return null;
    }

    @Override
    public String getClassifier() {
        return this.def.getClassifier();
    }

    @Override
    public String getDescription() {
        return this.def.getDescription();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public String getTitle() {
        return this.def.getTitle();
    }

    @Override
    @Deprecated
    public int getState() {
        return this.state.getValue();
    }

    @Override
    public PackageState getPackageState() {
        return this.state;
    }

    @Override
    public String[] getTargetPlatforms() {
        return this.def.getTargetPlatforms();
    }

    @Override
    public PackageDependency[] getDependencies() {
        return this.def.getDependencies();
    }

    @Override
    public PackageDependency[] getOptionalDependencies() {
        return this.def.getOptionalDependencies();
    }

    @Override
    public PackageDependency[] getConflicts() {
        return this.def.getConflicts();
    }

    @Override
    public PackageDependency[] getProvides() {
        return this.def.getProvides();
    }

    @Override
    public PackageType getType() {
        return this.def.getType();
    }

    @Override
    public Version getVersion() {
        return this.def.getVersion();
    }

    @Override
    public String getVendor() {
        return this.def.getVendor();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Task getInstallTask() throws PackageException {
        if (this.def.getInstaller() == null) {
            this.def.setInstaller(new TaskDefinitionImpl(this.service.getDefaultInstallTaskType(), false));
        } else if (this.def.getInstaller().getType() == null) {
            this.def.getInstaller().setType(this.service.getDefaultInstallTaskType());
        }
        return this.getTask(this.def.getInstaller());
    }

    @Override
    public Task getUninstallTask() throws PackageException {
        if (this.def.getUninstaller() == null) {
            this.def.setUninstaller(new TaskDefinitionImpl(this.service.getDefaultUninstallTaskType(), false));
        } else if (this.def.getUninstaller().getType() == null) {
            this.def.getUninstaller().setType(this.service.getDefaultUninstallTaskType());
        }
        return this.getTask(this.def.getUninstaller());
    }

    protected Task getTask(TaskDefinition tdef) throws PackageException {
        Task task;
        try {
            task = (Task)this.data.loadClass(tdef.getType()).getConstructor(PackageUpdateService.class).newInstance(this.service);
        }
        catch (ReflectiveOperationException e) {
            throw new PackageException("Could not instantiate custom task " + tdef.getType() + " for package " + this.getId(), e);
        }
        task.initialize(this, tdef.getRequireRestart());
        return task;
    }

    @Override
    public Validator getValidator() throws PackageException {
        if (this.def.getValidator() != null) {
            try {
                return (Validator)this.data.loadClass(this.def.getValidator()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PackageException("Could not instantiate custom validator " + this.def.getValidator() + " for package " + this.getId(), e);
            }
        }
        return null;
    }

    public Form[] getForms(String path) throws PackageException {
        File file = this.data.getEntry(path);
        if (file.isFile()) {
            Form[] formArray;
            FileInputStream in = new FileInputStream(file);
            try {
                FormsDefinition forms = (FormsDefinition)StandaloneUpdateService.getXmap().load(in);
                formArray = forms.getForms();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PackageException("Failed to load forms file: " + file);
                }
            }
            in.close();
            return formArray;
        }
        return null;
    }

    @Override
    public Form[] getValidationForms() throws PackageException {
        return this.getForms("forms/validation.xml");
    }

    @Override
    public Form[] getInstallForms() throws PackageException {
        return this.getForms("forms/install.xml");
    }

    @Override
    public Form[] getUninstallForms() throws PackageException {
        return this.getForms("forms/uninstall.xml");
    }

    @Override
    public String getTermsAndConditionsContent() throws PackageException {
        File file = this.data.getEntry("terms-and-conditions.txt");
        if (file.isFile()) {
            try {
                return FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new PackageException("Failed to read license.txt file for package: " + this.getId());
            }
        }
        return null;
    }

    @Override
    public boolean requireTermsAndConditionsAcceptance() {
        return this.def.requireTermsAndConditionsAcceptance();
    }

    @Override
    public boolean supportsHotReload() {
        return this.def.supportsHotReload();
    }

    public String toString() {
        return this.getId();
    }
}

