/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone.commands;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileRef;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.task.standalone.commands.Copy;
import org.nuxeo.connect.update.util.IOUtils;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Element;

public class Delete
extends AbstractCommand {
    protected static final Log log = LogFactory.getLog(Delete.class);
    public static final String ID = "delete";
    protected File file;
    protected String md5;
    protected boolean onExit;

    public Delete() {
        super(ID);
    }

    public Delete(File file, String md5) {
        this(file, md5, false);
    }

    public Delete(File file, String md5, boolean onExit) {
        super(ID);
        this.file = file;
        this.md5 = md5;
        this.onExit = onExit;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) {
        if (this.file == null) {
            status.addError("Invalid delete syntax: No file specified");
            return;
        }
        if (this.file.isDirectory()) {
            status.addError("Cannot delete directories: " + this.file.getName());
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        try {
            if (this.file.isFile()) {
                if (this.md5 != null && !this.md5.equals(IOUtils.createMd5(this.file))) {
                    return null;
                }
                File bak = IOUtils.backup(task.getPackage(), this.file);
                if (this.onExit) {
                    this.file.deleteOnExit();
                } else if (!this.file.delete()) {
                    throw new PackageException("Cannot delete " + this.file.getName());
                }
                return new Copy(bak, this.file, this.md5, false, this.onExit);
            }
            return null;
        }
        catch (IOException e) {
            throw new PackageException("Failed to create backup when deleting: " + this.file.getName(), e);
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            FileRef ref = FileRef.newFileRef(v);
            ref.fillPatternVariables(this.guardVars);
            this.file = ref.getFile();
            this.guardVars.put("file", this.file);
        }
        if ((v = element.getAttribute("md5")).length() > 0) {
            this.md5 = v;
        }
        if ((v = element.getAttribute("onExit")).length() > 0) {
            this.onExit = Boolean.parseBoolean(v);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        if (this.md5 != null) {
            writer.attr("md5", this.md5);
        }
        if (this.onExit) {
            writer.attr("onExit", "true");
        }
        writer.end();
    }
}

