/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.xml;

import org.apache.commons.text.StringEscapeUtils;

public class XmlWriter {
    protected final String tab;
    protected StringBuilder sb;
    protected String indent;
    protected int depth;

    public XmlWriter() {
        this("  ");
    }

    public XmlWriter(String tab) {
        this.tab = tab == null ? "" : tab;
        this.reset();
    }

    public void reset() {
        this.depth = 0;
        this.indent = "";
        this.sb = new StringBuilder(1024);
    }

    public void writeXmlDecl() {
        this.sb.append("<?xml version=\"1.0\"?>").append("\n\n");
    }

    protected void updateIndent() {
        if (this.depth <= 0) {
            this.indent = "";
            return;
        }
        int len = this.tab.length();
        if (len > 0) {
            StringBuilder buf = new StringBuilder(len * this.depth);
            for (int i = 0; i < this.depth; ++i) {
                buf.append(this.tab);
            }
            this.indent = buf.toString();
        }
    }

    protected final void inc() {
        ++this.depth;
        this.updateIndent();
    }

    protected final void dec() {
        --this.depth;
        this.updateIndent();
    }

    public final void start(String name) {
        this.sb.append(this.indent).append('<').append(name);
    }

    public final void end(String name) {
        this.dec();
        this.sb.append(this.indent).append("</").append(name).append(">\n");
    }

    public final void startContent() {
        this.sb.append(">\n");
        this.inc();
    }

    public final void end() {
        this.sb.append("/>\n");
    }

    public final void crlf() {
        this.sb.append("\n");
    }

    public final void attr(String name, String value) {
        if (value != null) {
            this.sb.append(" ").append(name).append("=\"").append(StringEscapeUtils.escapeXml10(value)).append("\"");
        }
    }

    protected void text(String text) {
        this.sb.append(text);
    }

    public void element(String name, String value) {
        if (value != null) {
            this.sb.append(this.indent).append('<').append(name).append('>').append(StringEscapeUtils.escapeXml10(value)).append("</").append(name).append(">\n");
        }
    }

    public StringBuilder getBuffer() {
        return this.sb;
    }

    public String toString() {
        return this.sb.toString();
    }
}

