/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.writer.JsonXmlStreamWriter;
import java.io.Console;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.validation.constraints.NotNull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.RegistrationException;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.Version;
import org.nuxeo.launcher.NuxeoJettyLauncher;
import org.nuxeo.launcher.NuxeoTomcatLauncher;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.connect.ConnectBroker;
import org.nuxeo.launcher.connect.ConnectRegistrationBroker;
import org.nuxeo.launcher.connect.LauncherRestartException;
import org.nuxeo.launcher.daemon.DaemonThreadFactory;
import org.nuxeo.launcher.gui.NuxeoLauncherGUI;
import org.nuxeo.launcher.info.CommandInfo;
import org.nuxeo.launcher.info.CommandSetInfo;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.InstanceInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.MessageInfo;
import org.nuxeo.launcher.info.PackageInfo;
import org.nuxeo.launcher.monitoring.StatusServletClient;
import org.nuxeo.launcher.process.MacProcessManager;
import org.nuxeo.launcher.process.ProcessManager;
import org.nuxeo.launcher.process.PureJavaProcessManager;
import org.nuxeo.launcher.process.SolarisProcessManager;
import org.nuxeo.launcher.process.UnixProcessManager;
import org.nuxeo.launcher.process.WindowsProcessManager;
import org.nuxeo.log4j.Log4JHelper;
import org.nuxeo.log4j.ThreadedStreamGobbler;

public abstract class NuxeoLauncher {
    protected static final String OUTPUT_UNSET_VALUE = "<unset>";
    protected static final String OPTION_NODEPS = "nodeps";
    private static final String OPTION_NODEPS_DESC = "Ignore package dependencies and constraints.";
    protected static final String OPTION_GUI = "gui";
    private static final String OPTION_GUI_DESC = "Start graphical user interface (default is true on Windows and false on other platforms).";
    protected static final String OPTION_JSON = "json";
    private static final String OPTION_JSON_DESC = "Output JSON for mp-* commands.";
    protected static final String OPTION_XML = "xml";
    private static final String OPTION_XML_DESC = "Output XML for mp-* commands.";
    protected static final String OPTION_DEBUG = "debug";
    private static final String OPTION_DEBUG_DESC = "Activate debug messages.\n<categories>: comma-separated Java categories to debug (default: \"org.nuxeo.launcher\").";
    private static final String OPTION_DEBUG_CATEGORY_ARG_NAME = "categories";
    protected static final String OPTION_DEBUG_CATEGORY = "dc";
    private static final String OPTION_DEBUG_CATEGORY_DESC = "Deprecated: see categories on '--debug' option.";
    protected static final String OPTION_QUIET = "quiet";
    private static final String OPTION_QUIET_DESC = "Suppress information messages.";
    protected static final String OPTION_HELP = "help";
    private static final String OPTION_HELP_DESC = "Show detailed help.";
    protected static final String OPTION_RELAX = "relax";
    private static final String OPTION_RELAX_DESC = "Allow relax constraint on current platform (default: ask).";
    protected static final String OPTION_ACCEPT = "accept";
    private static final String OPTION_ACCEPT_DESC = "Accept, refuse or ask confirmation for all changes (default: ask).\nIn non interactive mode, '--accept=true' also sets '--relax=true' if needed.";
    protected static final String OPTION_SNAPSHOT = "snapshot";
    private static final String OPTION_SNAPSHOT_DESC = "Allow use of SNAPSHOT Nuxeo Packages.\nThis option is implicit:\n\t- on SNAPSHOT distributions (daily builds),\n\t- if the command explicitly requests a SNAPSHOT package.";
    @Deprecated(since="11.1")
    protected static final String OPTION_FORCE = "force";
    @Deprecated(since="11.1")
    private static final String OPTION_FORCE_DESC = "Deprecated since 11.1: strict mode is the default.";
    @Deprecated(since="11.1")
    protected static final String OPTION_STRICT = "strict";
    @Deprecated(since="11.1")
    private static final String OPTION_STRICT_DESC = "Deprecated since 11.1: strict mode is the default.";
    protected static final String OPTION_LENIENT = "lenient";
    protected static final String OPTION_LENIENT_DESC = "Do not abort in error the start command when a component cannot be activated or if a server is already running.";
    protected static final String OPTION_HIDE_DEPRECATION = "hide-deprecation-warnings";
    protected static final String OPTION_HIDE_DEPRECATION_DESC = "Hide deprecation warnings.";
    protected static final String OPTION_IGNORE_MISSING = "ignore-missing";
    protected static final String OPTION_IGNORE_MISSING_DESC = "Ignore unknown packages on mp-add, mp-install and mp-set commands.";
    protected static final String OPTION_CLID = "clid";
    private static final String OPTION_CLID_DESC = "Use the provided instance CLID file";
    protected static final String OPTION_OFFLINE = "offline";
    private static final String OPTION_OFFLINE_DESC = "Allow offline registration";
    protected static final String OPTION_RENEW = "renew";
    private static final String OPTION_RENEW_DESC = "Renew the current CLID";
    protected static final String OPTION_ENCRYPT = "encrypt";
    private static final String OPTION_ENCRYPT_ARG_NAME = "algorithm";
    private static final String OPTION_ENCRYPT_DESC = String.format("Activate key value symmetric encryption.\nThe algorithm can be configured: <%s> is a cipher transformation of the form: \"algorithm/mode/padding\" or \"algorithm\".\nDefault value is \"%s\" (Advanced Encryption Standard, Electronic Cookbook Mode, PKCS5-style padding).", "encrypt", "AES/ECB/PKCS5Padding");
    protected static final String OPTION_SET = "set";
    private static final String OPTION_SET_ARG_NAME = "template";
    private static final String OPTION_SET_DESC = String.format("Set the value for a given key.\nThe value is stored in {{%s}} by default unless a template name is provided; if so, it is then stored in the template's {{%s}} file.\nIf the value is empty (''), then the property is unset.\nThis option is implicit if no '--get' or '--get-regexp' option is used and there are exactly two parameters (key value).", "nuxeo.conf", "nuxeo.defaults");
    protected static final String OPTION_GET = "get";
    private static final String OPTION_GET_DESC = "Get the value for a given key. Returns error code 6 if the key was not found.\nThis option is implicit if '--set' option is not used and there are more or less than two parameters.";
    protected static final String OPTION_GET_REGEXP = "get-regexp";
    private static final String OPTION_GET_REGEXP_DESC = "Get the value for all keys matching the given regular expression(s).";
    protected static final String OPTION_GZIP_OUTPUT = "gzip";
    private static final String OPTION_GZIP_DESC = "Compress the output.";
    protected static final String OPTION_OUTPUT = "output";
    private static final String OPTION_OUTPUT_DESC = "Write output in specified file.";
    protected static final String OPTION_PRETTY_PRINT = "pretty-print";
    private static final String OPTION_PRETTY_PRINT_DESC = "Pretty print the output.";
    private static final String DEFAULT_NUXEO_CONTEXT_PATH = "/nuxeo";
    private static final Logger log;
    private static Options options;
    private static final String JAVA_OPTS_PROPERTY = "launcher.java.opts";
    private static final String JAVA_OPTS_DEFAULT = "-Xms512m -Xmx1024m";
    private static final String OVERRIDE_JAVA_TMPDIR_PARAM = "launcher.override.java.tmpdir";
    protected boolean overrideJavaTmpDir;
    private static final String START_MAX_WAIT_PARAM = "launcher.start.max.wait";
    private static final String STOP_MAX_WAIT_PARAM = "launcher.stop.max.wait";
    private static final String START_MAX_WAIT_DEFAULT = "300";
    private static final String STOP_MAX_WAIT_DEFAULT = "60";
    private static final int STOP_NB_TRY = 5;
    private static final int STOP_SECONDS_BEFORE_NEXT_TRY = 2;
    private static final long STREAM_MAX_WAIT = 3000L;
    private static final String[] COMMANDS_NO_GUI;
    private static final String[] COMMANDS_NO_RUNNING_SERVER;
    public static final int STATUS_CODE_ON = 0;
    public static final int STATUS_CODE_OFF = 3;
    public static final int STATUS_CODE_UNKNOWN = 4;
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_ERROR = 1;
    public static final int EXIT_CODE_INVALID = 2;
    public static final int EXIT_CODE_UNIMPLEMENTED = 3;
    public static final int EXIT_CODE_UNAUTHORIZED = 4;
    public static final int EXIT_CODE_NOT_INSTALLED = 5;
    public static final int EXIT_CODE_NOT_CONFIGURED = 6;
    public static final int EXIT_CODE_NOT_RUNNING = 7;
    public static final int EXIT_CODE_LAUNCHER_CHANGED = 128;
    private static final String OPTION_HELP_DESC_ENV;
    private static final String OPTION_HELP_DESC_COMMANDS = "\nCOMMANDS\n        help\t\t\tPrint this message.\n        gui\t\t\tDeprecated: use '--gui' option instead.\n        start\t\t\tStart Nuxeo server in background, waiting for effective start. Useful for batch executions requiring the server being immediately available after the script returned.\n        stop\t\t\tStop any Nuxeo server started with the same {{nuxeo.conf}} file.\n        restart\t\t\tRestart Nuxeo server.\n        config\t\t\tGet and set template or global parameters.\n        encrypt\t\t\tOutput encrypted value for a given parameter.\n        decrypt\t\t\tOutput decrypted value for a given parameter.\n        configure\t\tConfigure Nuxeo server with parameters from {{nuxeo.conf}}.\n        console\t\t\tStart Nuxeo server in a console mode. Ctrl-C will stop it.\n        status\t\t\tPrint server running status.\n        startbg\t\t\tStart Nuxeo server in background, without waiting for effective start. Useful for starting Nuxeo as a service.\n        restartbg\t\tRestart Nuxeo server with a call to \"startbg\" after \"stop\".\n        pack\t\t\tBuild a static archive.\n        showconf\t\tDisplay the instance configuration.\n        mp-list\t\t\tList local Nuxeo Packages.\n        mp-listall\t\tList all Nuxeo Packages.\n        mp-init\t\t\tDeprecated: no more Nuxeo Packages locally available in the distribution.\n        mp-update\t\tUpdate cache of Nuxeo Packages list.\n        mp-add\t\t\tAdd Nuxeo Package(s) to local cache. You must provide the package file(s), name(s) or ID(s) as parameter.\n        mp-install\t\tRun Nuxeo Package installation. It is automatically called at startup if {{installAfterRestart.log}} file exists in data directory. Else you must provide the package file(s), name(s) or ID(s) as parameter.\n        mp-uninstall\t\tUninstall Nuxeo Package(s). You must provide the package name(s) or ID(s) as parameter (see \"mp-list\" command).\n        mp-remove\t\tRemove Nuxeo Package(s) from the local cache. You must provide the package name(s) or ID(s) as parameter (see \"mp-list\" command).\n        mp-reset\t\tReset all packages to DOWNLOADED state. May be useful after a manual server upgrade.\n        mp-set\t\t\tInstall a list of Nuxeo Packages and remove those not in the list.\n        mp-request\t\tInstall and uninstall Nuxeo Package(s) in one command. You must provide a *quoted* list of package names or IDs prefixed with + (install) or - (uninstall).\n        mp-purge\t\tUninstall and remove all packages from the local cache.\n        mp-hotfix\t\tInstall all the available hotfixes for the current platform but do not upgrade already installed ones (requires a registered instance).\n        mp-upgrade\t\tGet all the available upgrades for the Nuxeo Packages currently installed (requires a registered instance).\n        mp-show\t\t\tShow Nuxeo Package(s) information. You must provide the package file(s), name(s) or ID(s) as parameter.\n        register\t\tRegister your instance with an existing Connect account. You must provide the credentials, the project name or ID, its type and a description.\n        register-trial\t\tThis command is deprecated. To register for a free 30 day trial on Nuxeo Online Services, please visit https://connect.nuxeo.com/register\n\nThe following commands are always executed in console/headless mode (no GUI): \"configure\", \"mp-purge\", \"mp-add\", \"mp-install\", \"mp-uninstall\", \"mp-request\", \"mp-remove\", \"mp-hotfix\", \"mp-upgrade\", \"mp-reset\", \"mp-list\", \"mp-listall\", \"mp-update\", \"status\", \"showconf\", \"mp-show\", \"mp-set\", \"config\", \"encrypt\", \"decrypt\", \"help\".\n\nThe following commands cannot be executed on a running server: \"pack\", \"mp-purge\", \"mp-add\", \"mp-install\", \"mp-uninstall\", \"mp-request\", \"mp-remove\", \"mp-hotfix\", \"mp-upgrade\", \"mp-reset\".\n\nCommand parameters may need to be prefixed with '--' to separate them from option arguments when confusion arises.";
    private static final String OPTION_HELP_USAGE = "        nuxeoctl <command> [options] [--] [command parameters]\n\n";
    private static final String OPTION_HELP_HEADER = "SYNOPSIS\n        nuxeoctl encrypt [--encrypt <algorithm>] [<clearValue>..] [-d [<categories>]|-q]\n                Output encrypted value for <clearValue>.\n                If <clearValue> is not provided, it is read from stdin.\n\n        nuxeoctl decrypt '<cryptedValue>'.. [-d [<categories>]|-q]\n                Output decrypted value for <cryptedValue>. The secret key is read from stdin.\n\n        nuxeoctl config [<key> <value>].. <key> [<value>] [--encrypt [<algorithm>]] [--set [<template>]] [-d [<categories>]|-q]\n                Set template or global parameters.\n                If <value> is not provided and the --set 'option' is used, then the value is read from stdin.\n\n        nuxeoctl config [--get] <key>.. [-d [<categories>]|-q]\n                Get value for the given key(s).\n\n        nuxeoctl config [--get-regexp] <regexp>.. [-d [<categories>]|-q]\n                Get value for the keys matching the given regular expression(s).\n\n        nuxeoctl help|status|showconf [-d [<categories>]|-q]\n\n        nuxeoctl configure [-d [<categories>]|-q|-hdw]\n\n        nuxeoctl stop [-d [<categories>]|-q|--gui <true|false|yes|no>]\n\n        nuxeoctl start|restart|console|startbg|restartbg [-d [<categories>]|-q|--clid <arg>|--gui <true|false|yes|no>|--lenient|-hdw]\n\n        nuxeoctl mp-show [command parameters] [-d [<categories>]|-q|--clid <arg>|--xml|--json]\n\n        nuxeoctl mp-list|mp-listall|mp-update [command parameters] [-d [<categories>]|-q|--clid <arg>|--relax <true|false|yes|no>|--xml|--json]\n\n        nuxeoctl mp-reset|mp-purge|mp-hotfix|mp-upgrade [command parameters] [-d [<categories>]|-q|--clid <arg>|--xml|--json|--accept <true|false|yes|no|ask>]\n\n        nuxeoctl mp-add|mp-install|mp-uninstall|mp-remove|mp-set|mp-request [command parameters] [-d [<categories>]|-q|--clid <arg>|--xml|--json|--nodeps|--relax <true|false|yes|no|ask>|--accept <true|false|yes|no|ask>|-s|-im]\n\n        nuxeoctl register [<username> [<project> [<type> <description>] [<token>]]]\n                Register an instance with Nuxeo Online Services. Token can be created at https://connect.nuxeo.com/nuxeo/site/connect/tokens\n\n        nuxeoctl register --clid <arg>\n                Register an instance according to the given CLID file.\n\n        nuxeoctl register --renew [--clid <arg>]\n                Renew an instance registration with Nuxeo Online Services.\n\nOPTIONS";
    private static final String OPTION_HELP_FOOTER = "\nSee online documentation \"ADMINDOC/nuxeoctl and Control Panel Usage\": https://doc.nuxeo.com/x/FwNc";
    private static final int PAGE_SIZE = 20;
    public static final String CONNECT_TC_URL = "https://www.nuxeo.com/legal/nuxeo-trial-terms-conditions";
    protected ConfigurationGenerator configurationGenerator;
    protected ProcessManager processManager;
    protected Process nuxeoProcess;
    private String processRegex;
    protected String pid;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("NuxeoProcessThread", false));
    private ShutdownThread shutdownHook;
    protected String[] params;
    protected String command;
    public CommandSetInfo cset = new CommandSetInfo();
    private boolean useGui = false;
    private boolean reloadConfiguration = false;
    private int status = 4;
    private int errorValue = 0;
    private StatusServletClient statusServletClient;
    private static boolean quiet;
    private static boolean debug;
    private static boolean strict;
    private boolean xmlOutput = false;
    private boolean jsonOutput = false;
    private ConnectBroker connectBroker = null;
    private String clid = null;
    private ConnectRegistrationBroker connectRegistrationBroker = null;
    private InstanceInfo info;
    CommandLine cmdLine;
    private boolean ignoreMissing = false;
    private static Map<String, NuxeoLauncherGUI> guis;

    protected boolean commandRequiresNoRunningServer() {
        return Arrays.asList(COMMANDS_NO_RUNNING_SERVER).contains(this.command);
    }

    protected boolean commandRequiresNoGUI() {
        return Arrays.asList(COMMANDS_NO_GUI).contains(this.command);
    }

    public final ConfigurationGenerator getConfigurationGenerator() {
        return this.configurationGenerator;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean commandIs(String aCommand) {
        return StringUtils.equalsIgnoreCase(this.command, aCommand);
    }

    public boolean isUsingGui() {
        return this.useGui;
    }

    public boolean isQuiet() {
        return quiet;
    }

    public NuxeoLauncherGUI getGUI() {
        if (guis == null) {
            return null;
        }
        return guis.get(this.configurationGenerator.getNuxeoConf().toString());
    }

    public void setGUI(NuxeoLauncherGUI gui) {
        if (guis == null) {
            guis = new HashMap<String, NuxeoLauncherGUI>();
        }
        guis.put(this.configurationGenerator.getNuxeoConf().toString(), gui);
    }

    public NuxeoLauncher(ConfigurationGenerator configurationGenerator) {
        this.configurationGenerator = configurationGenerator;
        this.init();
    }

    public void init() {
        if (!this.configurationGenerator.init(true)) {
            throw new IllegalStateException("Initialization failed");
        }
        this.statusServletClient = new StatusServletClient(this.configurationGenerator);
        this.statusServletClient.setKey(this.configurationGenerator.getUserConfig().getProperty("server.status.key"));
        this.processManager = this.getOSProcessManager();
        this.processRegex = "^(?!/bin/sh).*" + Pattern.quote(this.configurationGenerator.getNuxeoConf().getPath()) + ".*" + Pattern.quote(this.getServerPrint()) + ".*$";
        if (SystemUtils.IS_OS_MAC) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "NuxeoCtl");
        }
    }

    private ProcessManager getOSProcessManager() {
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_AIX) {
            return new UnixProcessManager();
        }
        if (SystemUtils.IS_OS_MAC) {
            return new MacProcessManager();
        }
        if (SystemUtils.IS_OS_SUN_OS) {
            return new SolarisProcessManager();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsProcessManager windowsProcessManager = new WindowsProcessManager();
            return windowsProcessManager.isUsable() ? windowsProcessManager : new PureJavaProcessManager();
        }
        return new PureJavaProcessManager();
    }

    protected void start(boolean logProcessOutput) throws IOException, InterruptedException {
        ArrayList<String> startCommand = new ArrayList<String>();
        startCommand.add(this.getJavaExecutable().getPath());
        startCommand.addAll(this.getJavaOptsProperty(Function.identity()));
        startCommand.add("-cp");
        startCommand.add(this.getClassPath());
        startCommand.addAll(this.getNuxeoProperties());
        startCommand.addAll(this.getServerProperties());
        if (strict) {
            startCommand.add("-Dnuxeo.start.strict=true");
        }
        this.setServerStartCommand(startCommand);
        startCommand.addAll(Arrays.asList(this.params));
        ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(startCommand));
        pb.directory(this.configurationGenerator.getNuxeoHome());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = pb::command;
        log.debug("Server command: {}", supplierArray);
        this.nuxeoProcess = pb.start();
        Thread.sleep(1000L);
        boolean processExited = false;
        if (this.nuxeoProcess == null) {
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = pb::command;
            log.error("Server start failed with command: {}", supplierArray2);
            if (SystemUtils.IS_OS_WINDOWS && this.configurationGenerator.getNuxeoHome().getPath().contains(" ")) {
                log.error("The server path must not contain spaces under Windows.");
            }
            return;
        }
        try {
            int exitValue = this.nuxeoProcess.exitValue();
            if (exitValue != 0) {
                log.error("Server start failed ({}).", (Object)exitValue);
            }
            processExited = true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        this.logProcessStreams(this.nuxeoProcess, processExited || logProcessOutput);
        if (!processExited) {
            if (this.getPid() != null) {
                log.warn("Server started with process ID {}.", (Object)this.pid);
            } else {
                log.warn("Sent server start command but could not get process ID.");
            }
        }
    }

    protected List<String> getJavaOptsProperty(Function<String, String> mapper) {
        return this.configurationGenerator.getJavaOpts(mapper);
    }

    public void checkNoRunningServer() throws IllegalStateException {
        try {
            String existingPid = this.getPid();
            if (existingPid != null) {
                this.errorValue = 0;
                throw new IllegalStateException("A server is running with process ID " + existingPid);
            }
        }
        catch (IOException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            log.warn("Could not check existing process: {}", supplierArray);
        }
    }

    public ArrayList<ThreadedStreamGobbler> logProcessStreams(Process process, boolean logProcessOutput) {
        ThreadedStreamGobbler errorSG;
        ThreadedStreamGobbler inputSG;
        ArrayList<ThreadedStreamGobbler> sgArray = new ArrayList<ThreadedStreamGobbler>();
        if (logProcessOutput) {
            inputSG = new ThreadedStreamGobbler(process.getInputStream(), System.out);
            errorSG = new ThreadedStreamGobbler(process.getErrorStream(), System.err);
        } else {
            inputSG = new ThreadedStreamGobbler(process.getInputStream(), 7);
            errorSG = new ThreadedStreamGobbler(process.getErrorStream(), 7);
        }
        inputSG.start();
        errorSG.start();
        sgArray.add(inputSG);
        sgArray.add(errorSG);
        return sgArray;
    }

    protected abstract String getServerPrint();

    private List<String> getOSCommand(List<String> roughCommand) {
        if (SystemUtils.IS_OS_UNIX) {
            return this.getUnixCommand(roughCommand);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.getWindowsCommand(roughCommand);
        }
        throw new IllegalStateException("Unknown os, can't launch server");
    }

    private List<String> getWindowsCommand(List<String> roughCommand) {
        ArrayList<String> osCommand = new ArrayList<String>();
        for (String commandToken : roughCommand) {
            if (StringUtils.isBlank(commandToken)) continue;
            osCommand.add("\"" + commandToken + "\"");
        }
        return osCommand;
    }

    private List<String> getUnixCommand(List<String> roughCommand) {
        ArrayList<String> osCommand = new ArrayList<String>();
        StringBuilder linearizedCommand = new StringBuilder("exec");
        for (String commandToken : roughCommand) {
            if (StringUtils.isBlank(commandToken)) continue;
            if (commandToken.contains(" ")) {
                commandToken = commandToken.replaceAll(" ", "\\\\ ");
            }
            linearizedCommand.append(' ').append(commandToken);
        }
        osCommand.add("/bin/sh");
        osCommand.add("-c");
        osCommand.add(linearizedCommand.toString());
        return osCommand;
    }

    protected abstract Collection<? extends String> getServerProperties();

    protected abstract void setServerStartCommand(List<String> var1);

    private File getJavaExecutable() {
        return new File(System.getProperty("java.home"), "bin" + File.separator + "java");
    }

    protected abstract String getClassPath();

    protected abstract String getShutdownClassPath();

    protected Collection<String> getNuxeoProperties() {
        ArrayList<String> nuxeoProperties = new ArrayList<String>();
        nuxeoProperties.add(String.format("-D%s=%s", "nuxeo.home", this.configurationGenerator.getNuxeoHome().getPath()));
        nuxeoProperties.add(String.format("-D%s=%s", "nuxeo.conf", this.configurationGenerator.getNuxeoConf().getPath()));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.log.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.data.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.tmp.dir"));
        nuxeoProperties.add(this.getNuxeoProperty("nuxeo.mp.dir"));
        if (!DEFAULT_NUXEO_CONTEXT_PATH.equals(this.configurationGenerator.getUserConfig().getProperty("org.nuxeo.ecm.contextPath"))) {
            nuxeoProperties.add(this.getNuxeoProperty("org.nuxeo.ecm.contextPath"));
        }
        if (this.overrideJavaTmpDir) {
            nuxeoProperties.add("-Djava.io.tmpdir=" + this.configurationGenerator.getUserConfig().getProperty("nuxeo.tmp.dir"));
        }
        return nuxeoProperties;
    }

    private String getNuxeoProperty(String property) {
        return "-D" + property + "=" + this.configurationGenerator.getUserConfig().getProperty(property);
    }

    protected String addToClassPath(String cp, String filename) {
        File classPathEntry = new File(this.configurationGenerator.getNuxeoHome(), filename);
        if (!classPathEntry.exists()) {
            classPathEntry = new File(filename);
        }
        if (!classPathEntry.exists()) {
            throw new RuntimeException("Tried to add nonexistent classpath entry: " + filename);
        }
        cp = (String)cp + System.getProperty("path.separator") + classPathEntry.getPath();
        return cp;
    }

    protected static Options initParserOptions() {
        Options options = new Options();
        options.addOption(Option.builder("h").longOpt(OPTION_HELP).desc(OPTION_HELP_DESC).build());
        options.addOption(Option.builder("q").longOpt(OPTION_QUIET).desc(OPTION_QUIET_DESC).build());
        OptionGroup debugOptions = new OptionGroup();
        debugOptions.addOption(Option.builder("d").longOpt(OPTION_DEBUG).desc(OPTION_DEBUG_DESC).hasArgs().argName(OPTION_DEBUG_CATEGORY_ARG_NAME).optionalArg(true).valueSeparator(',').build());
        debugOptions.addOption(Option.builder(OPTION_DEBUG_CATEGORY).desc(OPTION_DEBUG_CATEGORY_DESC).hasArgs().argName(OPTION_DEBUG_CATEGORY_ARG_NAME).optionalArg(true).valueSeparator(',').build());
        options.addOptionGroup(debugOptions);
        options.addOption(Option.builder().longOpt("debug-launcher").desc("Linux-only. Activate Java debugging mode on the Launcher.").build());
        options.addOption(Option.builder().longOpt(OPTION_CLID).desc(OPTION_CLID_DESC).hasArg().build());
        options.addOption(Option.builder().longOpt(OPTION_OFFLINE).desc(OPTION_OFFLINE_DESC).build());
        options.addOption(Option.builder().longOpt(OPTION_RENEW).desc(OPTION_RENEW_DESC).build());
        OptionGroup outputOptions = new OptionGroup();
        outputOptions.addOption(Option.builder().longOpt(OPTION_XML).desc(OPTION_XML_DESC).build());
        outputOptions.addOption(Option.builder().longOpt(OPTION_JSON).desc(OPTION_JSON_DESC).build());
        options.addOptionGroup(outputOptions);
        options.addOption(Option.builder().longOpt(OPTION_GUI).desc(OPTION_GUI_DESC).hasArg().argName("true|false|yes|no").build());
        options.addOption(Option.builder().longOpt(OPTION_NODEPS).desc(OPTION_NODEPS_DESC).build());
        options.addOption(Option.builder().longOpt(OPTION_RELAX).desc(OPTION_RELAX_DESC).hasArg().argName("true|false|yes|no|ask").build());
        options.addOption(Option.builder().longOpt(OPTION_ACCEPT).desc(OPTION_ACCEPT_DESC).hasArg().argName("true|false|yes|no|ask").build());
        options.addOption(Option.builder("s").longOpt(OPTION_SNAPSHOT).desc(OPTION_SNAPSHOT_DESC).build());
        options.addOption(Option.builder("f").longOpt(OPTION_FORCE).desc("Deprecated since 11.1: strict mode is the default.").build());
        options.addOption(Option.builder().longOpt(OPTION_STRICT).desc("Deprecated since 11.1: strict mode is the default.").build());
        options.addOption(Option.builder().longOpt(OPTION_LENIENT).desc(OPTION_LENIENT_DESC).build());
        options.addOption(Option.builder("im").longOpt(OPTION_IGNORE_MISSING).desc(OPTION_IGNORE_MISSING_DESC).build());
        options.addOption(Option.builder("hdw").longOpt(OPTION_HIDE_DEPRECATION).desc(OPTION_HIDE_DEPRECATION_DESC).build());
        options.addOption(Option.builder().longOpt(OPTION_ENCRYPT).desc(OPTION_ENCRYPT_DESC).hasArg().argName(OPTION_ENCRYPT_ARG_NAME).optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_GZIP_OUTPUT).desc(OPTION_GZIP_DESC).hasArg().argName("true|false").optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_PRETTY_PRINT).desc(OPTION_PRETTY_PRINT_DESC).hasArg().argName("true|false").optionalArg(true).build());
        options.addOption(Option.builder().longOpt(OPTION_OUTPUT).desc(OPTION_OUTPUT_DESC).hasArg().argName("file").optionalArg(true).build());
        OptionGroup configOptions = new OptionGroup();
        configOptions.addOption(Option.builder().longOpt(OPTION_SET).desc(OPTION_SET_DESC).hasArg().argName(OPTION_SET_ARG_NAME).optionalArg(true).build());
        configOptions.addOption(Option.builder().longOpt(OPTION_GET).desc(OPTION_GET_DESC).build());
        configOptions.addOption(Option.builder().longOpt(OPTION_GET_REGEXP).desc(OPTION_GET_REGEXP_DESC).build());
        options.addOptionGroup(configOptions);
        return options;
    }

    protected static CommandLine parseOptions(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmdLine = parser.parse(options, args);
        if (cmdLine.hasOption(OPTION_HELP)) {
            cmdLine.getArgList().add(OPTION_HELP);
            NuxeoLauncher.setQuiet();
        } else if (cmdLine.getArgList().isEmpty()) {
            throw new ParseException("Missing command.");
        }
        if (cmdLine.hasOption(OPTION_QUIET) || cmdLine.hasOption(OPTION_XML) || cmdLine.hasOption(OPTION_JSON)) {
            NuxeoLauncher.setQuiet();
        }
        if (cmdLine.hasOption(OPTION_DEBUG)) {
            NuxeoLauncher.setDebug(cmdLine.getOptionValues(OPTION_DEBUG));
        }
        if (cmdLine.hasOption(OPTION_DEBUG_CATEGORY)) {
            NuxeoLauncher.setDebug(cmdLine.getOptionValues(OPTION_DEBUG_CATEGORY));
        }
        if (cmdLine.hasOption(OPTION_FORCE) || cmdLine.hasOption(OPTION_STRICT)) {
            log.warn("--force and --strict have no impact, Nuxeo is started in strict mode by default.");
        }
        if (cmdLine.hasOption(OPTION_LENIENT)) {
            NuxeoLauncher.setStrict(false);
        }
        return cmdLine;
    }

    public static void main(String[] args) {
        NuxeoLauncher launcher = null;
        try {
            launcher = NuxeoLauncher.createLauncher(args);
            if (launcher.commandRequiresNoGUI()) {
                launcher.useGui = false;
            }
            if (launcher.useGui && launcher.getGUI() == null) {
                launcher.setGUI(new NuxeoLauncherGUI(launcher));
            }
            NuxeoLauncher.launch(launcher);
        }
        catch (LauncherRestartException e) {
            log.info("Restarting launcher...");
            System.exit(128);
        }
        catch (ParseException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            log.error("Invalid command line. {}", supplierArray);
            log.debug(e, (Throwable)e);
            NuxeoLauncher.printShortHelp();
            System.exit(launcher == null || launcher.errorValue == 0 ? 2 : launcher.errorValue);
        }
        catch (IOException | GeneralSecurityException | PackageException | ConfigurationException e) {
            log.error(e.getMessage());
            log.debug(e, (Throwable)e);
            System.exit(launcher == null || launcher.errorValue == 0 ? 2 : launcher.errorValue);
        }
        catch (Exception e) {
            log.error("Cannot execute command. {}", (Object)e.getMessage(), (Object)e);
            log.debug(e, (Throwable)e);
            System.exit(1);
        }
    }

    public static void launch(NuxeoLauncher launcher) throws IOException, PackageException, ConfigurationException, ParseException, GeneralSecurityException {
        boolean commandSucceeded = true;
        if (launcher.commandIs(null)) {
            return;
        }
        if (launcher.commandRequiresNoRunningServer()) {
            launcher.checkNoRunningServer();
        }
        if (launcher.commandIs(OPTION_HELP)) {
            NuxeoLauncher.printLongHelp();
        } else if (launcher.commandIs("status")) {
            String statusMsg = launcher.status();
            launcher.errorValue = launcher.getStatus();
            if (!quiet) {
                log.warn(statusMsg);
                if (launcher.isStarted()) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = launcher::getURL;
                    log.info("Go to {}", supplierArray);
                    log.info(launcher.getStartupSummary());
                }
            }
        } else if (launcher.commandIs("startbg")) {
            commandSucceeded = launcher.doStart();
        } else if (launcher.commandIs("start")) {
            if (launcher.useGui) {
                launcher.getGUI().start();
            } else {
                commandSucceeded = launcher.doStartAndWait();
            }
        } else if (launcher.commandIs("console")) {
            launcher.executor.execute(() -> {
                launcher.addShutdownHook();
                try {
                    if (!launcher.doStart(true)) {
                        launcher.removeShutdownHook();
                        System.exit(1);
                    } else if (!quiet) {
                        Supplier[] supplierArray = new Supplier[1];
                        supplierArray[0] = launcher::getURL;
                        log.info("Go to {}", supplierArray);
                    }
                }
                catch (PackageException e) {
                    log.error("Could not initialize the packaging subsystem", (Throwable)e);
                    launcher.removeShutdownHook();
                    System.exit(1);
                }
            });
        } else if (launcher.commandIs("stop")) {
            if (launcher.useGui) {
                launcher.getGUI().stop();
            } else {
                launcher.stop();
            }
        } else if (launcher.commandIs("restartbg")) {
            launcher.stop();
            commandSucceeded = launcher.doStart();
        } else if (launcher.commandIs("restart")) {
            launcher.stop();
            commandSucceeded = launcher.doStartAndWait();
        } else if (launcher.commandIs("configure")) {
            launcher.configure();
        } else if (launcher.commandIs("mp-list")) {
            launcher.pkgList();
        } else if (launcher.commandIs("mp-listall")) {
            launcher.pkgListAll();
        } else if (launcher.commandIs("mp-init")) {
            commandSucceeded = launcher.pkgInit();
        } else if (launcher.commandIs("mp-purge")) {
            commandSucceeded = launcher.pkgPurge();
        } else if (launcher.commandIs("mp-add")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgAdd(launcher.params) : launcher.pkgRequest(Arrays.asList(launcher.params), null, null, null);
        } else if (launcher.commandIs("mp-install")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgInstall(launcher.params) : launcher.pkgRequest(null, Arrays.asList(launcher.params), null, null);
        } else if (launcher.commandIs("mp-uninstall")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgUninstall(launcher.params) : launcher.pkgRequest(null, null, Arrays.asList(launcher.params), null);
        } else if (launcher.commandIs("mp-remove")) {
            commandSucceeded = launcher.cmdLine.hasOption(OPTION_NODEPS) ? launcher.pkgRemove(launcher.params) : launcher.pkgRequest(null, null, null, Arrays.asList(launcher.params));
        } else if (launcher.commandIs("mp-request")) {
            if (launcher.cmdLine.hasOption(OPTION_NODEPS)) {
                throw new ParseException("The command mp-request is not available with the --nodeps option");
            }
            commandSucceeded = launcher.pkgCompoundRequest(Arrays.asList(launcher.params));
        } else if (launcher.commandIs("mp-set")) {
            commandSucceeded = launcher.pkgSetRequest(Arrays.asList(launcher.params), launcher.cmdLine.hasOption(OPTION_NODEPS));
        } else if (launcher.commandIs("mp-hotfix")) {
            commandSucceeded = launcher.pkgHotfix();
        } else if (launcher.commandIs("mp-upgrade")) {
            commandSucceeded = launcher.pkgUpgrade();
        } else if (launcher.commandIs("mp-reset")) {
            commandSucceeded = launcher.pkgReset();
        } else if (launcher.commandIs("mp-update")) {
            commandSucceeded = launcher.pkgRefreshCache();
        } else if (launcher.commandIs("showconf")) {
            launcher.showConfig();
        } else if (launcher.commandIs("mp-show")) {
            commandSucceeded = launcher.pkgShow(launcher.params);
        } else if (launcher.commandIs(OPTION_ENCRYPT)) {
            launcher.encrypt();
        } else if (launcher.commandIs("decrypt")) {
            launcher.decrypt();
        } else if (launcher.commandIs("config")) {
            launcher.config();
        } else if (launcher.commandIs("register")) {
            commandSucceeded = launcher.register();
        } else if (launcher.commandIs("register-trial")) {
            commandSucceeded = launcher.registerTrial();
        } else {
            log.error("Unknown command {}", (Object)launcher.command);
            NuxeoLauncher.printLongHelp();
            launcher.errorValue = 2;
        }
        if (launcher.xmlOutput && launcher.command.startsWith("mp-")) {
            launcher.printXMLOutput();
        }
        boolean bl = commandSucceeded = commandSucceeded && launcher.errorValue == 0;
        if (!commandSucceeded && !quiet || debug) {
            launcher.cset.log(commandSucceeded);
        }
        if (!commandSucceeded) {
            System.exit(launcher.errorValue);
        }
    }

    protected static OutputStream openOutput(Path path, boolean gzip) throws IOException {
        OutputStream output = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        if (gzip) {
            output = new GZIPOutputStream(output);
        }
        return output;
    }

    public String promptEmail() throws IOException, ConfigurationException {
        EmailValidator validator = EmailValidator.getInstance();
        String message = "Email Address: ";
        String error = "Invalid email address.";
        return this.prompt("Email Address: ", validator::isValid, "Invalid email address.");
    }

    public String promptDescription() throws ConfigurationException, IOException {
        return this.prompt("Description: ", null, null);
    }

    public String prompt(String message, Predicate<String> predicate, String error) throws IOException, ConfigurationException {
        String value;
        boolean doRegexMatch = predicate != null;
        Console console = System.console();
        if (console != null) {
            value = console.readLine(message, new Object[0]);
            while (value == null || doRegexMatch && !predicate.test(value)) {
                console.printf(error + "\n", value);
                value = console.readLine(message, new Object[0]);
            }
        } else {
            value = IOUtils.toString(System.in, StandardCharsets.UTF_8);
            if (value == null || doRegexMatch && !predicate.test(value)) {
                throw new ConfigurationException(error);
            }
        }
        return value;
    }

    public char[] promptPassword(String message) throws IOException {
        Console console = System.console();
        if (console != null) {
            return console.readPassword(message, new Object[0]);
        }
        return IOUtils.toCharArray(System.in, StandardCharsets.UTF_8);
    }

    @Deprecated
    public char[] promptPassword(boolean confirmation) throws IOException, ConfigurationException {
        char[] pwdVerification;
        char[] pwd = this.promptPassword("Please enter your password: ");
        if (confirmation && !Arrays.equals(pwd, pwdVerification = this.promptPassword("Please re-enter your password: "))) {
            throw new ConfigurationException("Passwords do not match.");
        }
        return pwd;
    }

    public char[] promptToken() throws IOException {
        return this.promptPassword("Please enter your token: ");
    }

    public NuxeoClientInstanceType promptInstanceType() throws IOException, ConfigurationException {
        String s;
        NuxeoClientInstanceType type;
        Console console = System.console();
        if (console == null) {
            String typeStr = IOUtils.toString(System.in, StandardCharsets.UTF_8);
            NuxeoClientInstanceType type2 = NuxeoClientInstanceType.fromString(typeStr);
            if (type2 == null) {
                throw new ConfigurationException("Unknown type: " + typeStr);
            }
            return type2;
        }
        while ((type = StringUtils.isBlank(s = console.readLine("Instance type (dev|preprod|prod): [dev] ", new Object[0])) ? NuxeoClientInstanceType.DEV : NuxeoClientInstanceType.fromString(s)) == null) {
        }
        return type;
    }

    public ConnectProject promptProject(@NotNull List<ConnectProject> projects) throws ConfigurationException, IOException, PackageException {
        if (projects.isEmpty()) {
            throw new ConfigurationException("You don't have access to any project.");
        }
        if (projects.size() == 1) {
            return projects.get(0);
        }
        Console console = System.console();
        if (console == null) {
            String projectName = IOUtils.toString(System.in, StandardCharsets.UTF_8);
            ConnectProject project2 = this.getConnectRegistrationBroker().getProjectByName(projectName, projects);
            if (project2 == null) {
                throw new ConfigurationException("Unknown project: " + projectName);
            }
            return project2;
        }
        System.out.println("Available projects:");
        int i = 0;
        boolean hasNextPage = true;
        while (true) {
            String projectName;
            if (i > 0 && !SystemUtils.IS_OS_WINDOWS) {
                System.out.print("\u001b[1A\u001b[2K");
            }
            int fromIndex = i * 20;
            int toIndex = (i + 1) * 20;
            if (toIndex >= projects.size()) {
                toIndex = projects.size();
                hasNextPage = false;
            }
            projects.subList(fromIndex, toIndex).forEach(project -> System.out.println("\t- " + project.getSymbolicName()));
            if (toIndex < projects.size()) {
                int pageLeft = (projects.size() - i * 20 + 20 - 1) / 20;
                System.out.print(String.format("Project name (press Enter for next page; %d pages left): ", pageLeft));
            } else {
                System.out.print("Project name: ");
            }
            if (hasNextPage) {
                ++i;
            }
            if (!StringUtils.isNotEmpty(projectName = console.readLine())) continue;
            ConnectProject project3 = this.getConnectRegistrationBroker().getProjectByName(projectName, projects);
            if (project3 != null) {
                return project3;
            }
            System.err.println("Unknown project: " + projectName);
            i = 0;
            hasNextPage = true;
        }
    }

    public boolean register() throws IOException, ConfigurationException, PackageException {
        if (this.cmdLine.hasOption(OPTION_RENEW)) {
            if (this.params.length != 0) {
                throw new ConfigurationException("Unexpected arguments for --renew.");
            }
            return this.registerRenew();
        }
        if (this.cmdLine.hasOption(OPTION_CLID) && this.params.length == 0) {
            return this.registerSaveCLID();
        }
        if (this.cmdLine.hasOption(OPTION_OFFLINE) && this.params.length == 0) {
            return this.registerOffline();
        }
        return this.registerRemoteInstance();
    }

    protected boolean registerRenew() throws IOException {
        try {
            this.getConnectRegistrationBroker().remoteRenewRegistration();
        }
        catch (RegistrationException e) {
            log.debug(e, (Throwable)e);
            this.errorValue = 1;
            return false;
        }
        log.info("Server registration renewed");
        return true;
    }

    protected boolean registerSaveCLID() throws IOException, ConfigurationException {
        try {
            this.getConnectBroker().saveCLID();
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            throw new ConfigurationException(e);
        }
        log.info("Server registration saved");
        return true;
    }

    protected boolean registerOffline() throws IOException, ConfigurationException {
        log.info("\nTo register your instance:");
        log.info("1. Visit {}/connect/registerInstance", ConnectUrlConfig::getBaseUrl);
        log.info("2. Select the project on which you want the instance to be registered and copy the technical identifier found below (CTID):\n\n{}\n", () -> TechnicalInstanceIdentifier.instance().getCTID());
        Date expirationDate = new Date();
        this.prompt("3. Enter the given identifier to register your instance (CLID): ", strCLID -> {
            try {
                this.getConnectRegistrationBroker().registerLocal((String)strCLID, "");
                long timestamp = Long.parseLong(StringUtils.substringBetween(strCLID, ".", "."));
                expirationDate.setTime(timestamp * 1000L);
            }
            catch (IOException | NumberFormatException | ConfigurationException e) {
                return false;
            }
            return true;
        }, "This identifier is invalid or cannot be read properly or cannot be saved.");
        log.info("Server registration saved");
        log.info("Your Nuxeo Online Services is valid until {}", (Object)expirationDate);
        return true;
    }

    protected boolean registerRemoteInstance() throws IOException, ConfigurationException, PackageException {
        String description;
        NuxeoClientInstanceType type;
        ConnectProject project;
        if (this.params.length > 5) {
            throw new ConfigurationException("Wrong number of arguments.");
        }
        String username = this.params.length > 0 ? this.params[0] : this.prompt("Username: ", StringUtils::isNotBlank, "Username cannot be empty.");
        char[] token = this.params.length == 3 || this.params.length == 5 ? this.params[this.params.length - 1].toCharArray() : this.promptToken();
        List<ConnectProject> projs = this.getConnectRegistrationBroker().getAvailableProjects(username, token);
        if (this.params.length > 1) {
            String projectName = this.params[1];
            project = this.getConnectRegistrationBroker().getProjectByName(projectName, projs);
            if (project == null) {
                throw new ConfigurationException("Unknown project: " + projectName);
            }
        } else {
            project = this.promptProject(projs);
        }
        if (this.params.length > 3) {
            type = NuxeoClientInstanceType.fromString(this.params[2]);
            if (type == null) {
                throw new ConfigurationException("Unknown type: " + this.params[2]);
            }
            description = this.params[3];
        } else {
            type = this.promptInstanceType();
            description = this.promptDescription();
        }
        return this.registerRemoteInstance(username, token, project, type, description);
    }

    protected boolean registerRemoteInstance(String username, char[] token, ConnectProject project, NuxeoClientInstanceType type, String description) throws IOException, ConfigurationException {
        this.getConnectRegistrationBroker().registerRemote(username, token, project.getUuid(), type, description);
        log.info(String.format("Server registered to {} for project {}\nType: {}\nDescription: {}", new Object[]{username, project, type, description}));
        return true;
    }

    @Deprecated
    public boolean registerTrial() throws IOException, ConfigurationException, PackageException {
        String msg = "This command is deprecated. To register for a free 30 day trial on Nuxeo Online Services, please visit https://connect.nuxeo.com/register";
        throw new UnsupportedOperationException(msg);
    }

    protected void encrypt() throws GeneralSecurityException {
        Crypto crypto = this.configurationGenerator.getCrypto();
        String algorithm = this.cmdLine.getOptionValue(OPTION_ENCRYPT, null);
        if (this.params.length == 0) {
            String encryptedString;
            Console console = System.console();
            if (console != null) {
                encryptedString = crypto.encrypt(algorithm, Crypto.getBytes(console.readPassword("Please enter the value to encrypt: ", new Object[0])));
            } else {
                try {
                    encryptedString = crypto.encrypt(algorithm, IOUtils.toByteArray(System.in));
                }
                catch (IOException e) {
                    log.debug(e, (Throwable)e);
                    this.errorValue = 1;
                    return;
                }
            }
            System.out.println(encryptedString);
        } else {
            for (String strToEncrypt : this.params) {
                String encryptedString = crypto.encrypt(algorithm, strToEncrypt.getBytes());
                System.out.println(encryptedString);
            }
        }
    }

    protected void decrypt() {
        Crypto crypto = this.configurationGenerator.getCrypto();
        this.askCryptoKeyAndDecrypt(crypto, this.params).forEach(System.out::println);
    }

    protected List<String> askCryptoKeyAndDecrypt(Crypto crypto, String ... values) {
        boolean validKey;
        Console console = System.console();
        if (console != null) {
            validKey = crypto.verifyKey(console.readPassword("Please enter the secret key: ", new Object[0]));
        } else {
            try {
                validKey = crypto.verifyKey(IOUtils.toByteArray(System.in));
            }
            catch (IOException e) {
                log.debug(e, (Throwable)e);
                this.errorValue = 1;
                return null;
            }
        }
        if (!validKey) {
            this.errorValue = 2;
            return null;
        }
        return Stream.of(values).map(crypto::decrypt).map(Crypto::getChars).map(String::new).collect(Collectors.toList());
    }

    protected void config() throws ConfigurationException, IOException, GeneralSecurityException {
        if (this.cmdLine.hasOption(OPTION_SET) || !this.cmdLine.hasOption(OPTION_GET) && !this.cmdLine.hasOption(OPTION_GET_REGEXP) && this.params.length == 2) {
            this.setConfigProperties();
        } else {
            this.getConfigProperties();
        }
    }

    protected void getConfigProperties() {
        List<Object> keys;
        boolean isRegexp = this.cmdLine.hasOption(OPTION_GET_REGEXP);
        CryptoProperties userConfig = this.configurationGenerator.getUserConfig();
        if (isRegexp) {
            keys = new ArrayList();
            for (Object key : userConfig.keySet()) {
                for (String param : this.params) {
                    Pattern pattern = Pattern.compile(param, 2);
                    if (!pattern.matcher((String)key).find()) continue;
                    keys.add((String)key);
                }
            }
            if (keys.isEmpty()) {
                this.errorValue = 6;
            }
        } else {
            keys = Arrays.asList(this.params);
        }
        Crypto crypto = userConfig.getCrypto();
        boolean keyChecked = false;
        boolean raw = true;
        StringBuilder sb = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        for (String string : keys) {
            String value = userConfig.getProperty(string, raw);
            if (value == null) {
                this.errorValue = 6;
                sb.append(OUTPUT_UNSET_VALUE).append(newLine);
                continue;
            }
            if (raw && !keyChecked && Crypto.isEncrypted(value)) {
                keyChecked = true;
                List<String> decryptedValues = this.askCryptoKeyAndDecrypt(crypto, value);
                if (decryptedValues != null) {
                    raw = false;
                    value = decryptedValues.get(0);
                }
            }
            if (isRegexp) {
                sb.append(string).append('=');
            }
            sb.append(value).append(newLine);
        }
        System.out.print(sb.toString());
    }

    protected void setConfigProperties() throws ConfigurationException, IOException, GeneralSecurityException {
        Crypto crypto = this.configurationGenerator.getCrypto();
        boolean doEncrypt = this.cmdLine.hasOption(OPTION_ENCRYPT);
        String algorithm = this.cmdLine.getOptionValue(OPTION_ENCRYPT, null);
        HashMap<String, String> changedParameters = new HashMap<String, String>();
        Iterator<String> iterator = Arrays.asList(this.params).iterator();
        while (iterator.hasNext()) {
            String value;
            String key = iterator.next();
            if (iterator.hasNext()) {
                value = iterator.next();
                if (doEncrypt) {
                    value = crypto.encrypt(algorithm, value.getBytes());
                } else if ("server.crypt.secretkey".equals(key) || "server.crypt.keystore.pass".equals(key)) {
                    value = Base64.encodeBase64String(value.getBytes());
                }
            } else {
                Console console = System.console();
                if (console != null) {
                    String fmt = "Please enter the value for %s: ";
                    value = doEncrypt ? crypto.encrypt(algorithm, Crypto.getBytes(console.readPassword("Please enter the value for %s: ", key))) : ("server.crypt.secretkey".equals(key) || "server.crypt.keystore.pass".equals(key) ? Base64.encodeBase64String(Crypto.getBytes(console.readPassword("Please enter the value for %s: ", key))) : console.readLine("Please enter the value for %s: ", key));
                } else {
                    try {
                        value = doEncrypt ? crypto.encrypt(algorithm, IOUtils.toByteArray(System.in)) : ("server.crypt.secretkey".equals(key) || "server.crypt.keystore.pass".equals(key) ? Base64.encodeBase64String(IOUtils.toByteArray(System.in)) : IOUtils.toString(System.in, StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        log.debug(e, (Throwable)e);
                        this.errorValue = 1;
                        return;
                    }
                }
            }
            changedParameters.put(key, value);
        }
        String template = this.cmdLine.getOptionValue(OPTION_SET);
        Map<String, String> oldValues = template == null ? this.configurationGenerator.setProperties(changedParameters) : this.configurationGenerator.setProperties(template, changedParameters);
        log.debug("Old values: {}", (Object)oldValues);
    }

    public boolean doStartAndWait() throws PackageException {
        boolean started = this.doStartAndWait(false);
        if (started && !quiet) {
            log.info("Go to {}", this::getURL);
        }
        return started;
    }

    public void stop() {
        this.stop(false);
    }

    public boolean doStart() throws PackageException {
        boolean started = this.doStart(false);
        if (started && !quiet) {
            log.info("Go to {}", this::getURL);
        }
        return started;
    }

    public boolean doStartAndWait(boolean logProcessOutput) throws PackageException {
        boolean commandSucceeded = false;
        if (this.doStart(logProcessOutput)) {
            this.addShutdownHook();
            try {
                if (this.waitForEffectiveStart()) {
                    commandSucceeded = true;
                }
                this.removeShutdownHook();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return commandSucceeded;
    }

    protected void removeShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            log.debug("Removed shutdown hook");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected boolean waitForEffectiveStart() throws InterruptedException {
        long deltaTime;
        long startTime = new Date().getTime();
        int startMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(START_MAX_WAIT_PARAM, this.getDefaultMaxWait()));
        log.debug("Will wait for effective start during {} seconds.", (Object)startMaxWait);
        StringBuilder startSummary = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        boolean isReady = false;
        do {
            block13: {
                try {
                    isReady = this.statusServletClient.init();
                }
                catch (SocketTimeoutException e) {
                    if (quiet) break block13;
                    System.out.print(".");
                }
            }
            deltaTime = (new Date().getTime() - startTime) / 1000L;
        } while (!isReady && deltaTime < (long)startMaxWait && this.isRunning());
        do {
            if (!(isReady = this.isStarted())) {
                if (!quiet) {
                    System.out.print(".");
                }
                Thread.sleep(1000L);
            }
            deltaTime = (new Date().getTime() - startTime) / 1000L;
        } while (!isReady && deltaTime < (long)startMaxWait && this.isRunning());
        if (isReady) {
            startSummary.append(newLine).append(this.getStartupSummary());
            long duration = (new Date().getTime() - startTime) / 1000L;
            startSummary.append(String.format("Started in %dmin%02ds", duration / 60L, duration % 60L));
            if (this.wasStartupFine()) {
                if (!quiet) {
                    System.out.println(startSummary);
                }
            } else {
                System.err.println(startSummary);
                if (strict) {
                    this.errorValue = 1;
                    log.error("Shutting down because of unstarted component in strict mode...");
                    this.stop();
                    return false;
                }
            }
            return true;
        }
        if (deltaTime >= (long)startMaxWait) {
            if (!quiet) {
                System.out.println();
            }
            log.error("Starting process is taking too long - giving up.");
        }
        this.errorValue = 1;
        return false;
    }

    public boolean wasStartupFine() {
        return this.statusServletClient.isStartupFine();
    }

    public String getStartupSummary() {
        try {
            return this.statusServletClient.getStartupSummary();
        }
        catch (SocketTimeoutException e) {
            log.warn("Failed to contact Nuxeo for getting startup summary", (Throwable)e);
            return "";
        }
    }

    public boolean doStart(boolean logProcessOutput) throws PackageException {
        boolean serverStarted;
        block15: {
            this.errorValue = 0;
            serverStarted = false;
            try {
                if (this.reloadConfiguration) {
                    this.configurationGenerator = new ConfigurationGenerator(quiet, debug);
                    this.configurationGenerator.init();
                } else {
                    this.reloadConfiguration = true;
                }
                this.configure();
                this.configurationGenerator.verifyInstallation();
                log.debug("Check if install in progress...");
                if (this.configurationGenerator.isInstallInProgress()) {
                    if (!this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, true, this.ignoreMissing)) {
                        this.errorValue = 1;
                        log.error("Start interrupted due to failure on pending actions. You can resume with a new start; or you can restore the file '{}', optionally using the '--{}' option.", (Object)this.configurationGenerator.getInstallFile().getName(), (Object)OPTION_IGNORE_MISSING);
                        return false;
                    }
                    return this.doStart(logProcessOutput);
                }
                this.start(logProcessOutput);
                serverStarted = this.isRunning();
                if (this.pid == null) break block15;
                File pidFile = new File(this.configurationGenerator.getPidDir(), "nuxeo.pid");
                try (FileWriter writer = new FileWriter(pidFile);){
                    writer.write(this.pid);
                }
            }
            catch (ConfigurationException e) {
                this.errorValue = 6;
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = e::getMessage;
                log.error("Could not run configuration: {}", supplierArray);
                log.debug(e, (Throwable)e);
            }
            catch (IOException e) {
                this.errorValue = 1;
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = e::getMessage;
                log.error("Could not start process: {}", supplierArray);
                log.debug(e, (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (IllegalStateException e) {
                if (strict) {
                    this.errorValue = 6;
                }
                log.error(e.getMessage());
            }
        }
        return serverStarted;
    }

    protected void printXMLOutput() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(CommandSetInfo.class, CommandInfo.class, PackageInfo.class, MessageInfo.class);
            this.printXMLOutput(jaxbContext, this.cset);
        }
        catch (JAXBException e) {
            log.error("Output serialization failed: {}", (Object)e.getMessage(), (Object)e);
            this.errorValue = 7;
        }
    }

    protected void printXMLOutput(JAXBContext jaxbContext, Object objectToOutput) {
        try {
            this.printXMLOutput(jaxbContext, objectToOutput, System.out);
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            log.error("Output serialization failed: {}", (Object)e.getMessage(), (Object)e);
            this.errorValue = 7;
        }
    }

    protected void printXMLOutput(JAXBContext context, Object object, OutputStream out) throws XMLStreamException, FactoryConfigurationError, JAXBException {
        XMLStreamWriter writer = this.jsonOutput ? this.jsonWriter(context, out) : this.xmlWriter(context, out);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        marshaller.marshal(object, writer);
    }

    protected XMLStreamWriter jsonWriter(JAXBContext context, OutputStream out) {
        JSONConfiguration config = JSONConfiguration.mapped().rootUnwrapping(true).attributeAsElement("key", "value").build();
        config = JSONConfiguration.createJSONConfigurationWithFormatted(config, true);
        return JsonXmlStreamWriter.createWriter(new OutputStreamWriter(out), config, "");
    }

    protected XMLStreamWriter xmlWriter(JAXBContext context, OutputStream out) throws XMLStreamException, FactoryConfigurationError {
        return XMLOutputFactory.newInstance().createXMLStreamWriter(out);
    }

    public void waitForProcessStreams(ArrayList<ThreadedStreamGobbler> sgArray) {
        for (ThreadedStreamGobbler streamGobbler : sgArray) {
            try {
                streamGobbler.join(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                streamGobbler.interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    protected String getClassPath(String classpath, File baseDir) {
        File[] files = this.getFilename(baseDir, ".*");
        StringBuilder sb = new StringBuilder(classpath);
        for (File file : files) {
            sb.append(System.getProperty("path.separator")).append(file.getPath());
        }
        return sb.toString();
    }

    protected File[] getFilename(File baseDir, String filePattern) {
        return baseDir.listFiles((basedir, filename) -> filename.matches(filePattern + "(-[0-9].*)?\\.jar"));
    }

    protected void addShutdownHook() {
        log.debug("Add shutdown hook");
        this.shutdownHook = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop(boolean logProcessOutput) {
        long startTime = new Date().getTime();
        try {
            if (!this.isRunning()) {
                log.warn("Server is not running.");
                return;
            }
            if (!quiet) {
                System.out.print("\nStopping server...");
            }
            int nbTry = 0;
            boolean retry = false;
            int stopMaxWait = Integer.parseInt(this.configurationGenerator.getUserConfig().getProperty(STOP_MAX_WAIT_PARAM, STOP_MAX_WAIT_DEFAULT));
            do {
                ArrayList<String> stopCommand = new ArrayList<String>();
                stopCommand.add(this.getJavaExecutable().getPath());
                stopCommand.add("-cp");
                stopCommand.add(this.getShutdownClassPath());
                stopCommand.addAll(this.getNuxeoProperties());
                stopCommand.addAll(this.getServerProperties());
                this.setServerStopCommand(stopCommand);
                stopCommand.addAll(Arrays.asList(this.params));
                ProcessBuilder pb = new ProcessBuilder(this.getOSCommand(stopCommand));
                pb.directory(this.configurationGenerator.getNuxeoHome());
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = pb::command;
                log.debug("Server command: {}", supplierArray);
                try {
                    long deltaTime;
                    Process stopProcess = pb.start();
                    ArrayList<ThreadedStreamGobbler> sgArray = this.logProcessStreams(stopProcess, logProcessOutput);
                    stopProcess.waitFor();
                    this.waitForProcessStreams(sgArray);
                    boolean wait = true;
                    while (wait) {
                        try {
                            if (stopProcess.exitValue() == 0) {
                                retry = false;
                            } else {
                                boolean bl = retry = ++nbTry < 5;
                                if (!quiet) {
                                    System.out.print(".");
                                }
                                Thread.sleep(2000L);
                            }
                            wait = false;
                        }
                        catch (IllegalThreadStateException e) {
                            wait = true;
                            if (!quiet) {
                                System.out.print(".");
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    if (!this.processManager.canFindPid()) {
                        log.warn("Can't check server status on your OS.");
                        return;
                    }
                    do {
                        if (!quiet) {
                            System.out.print(".");
                        }
                        Thread.sleep(1000L);
                        deltaTime = (new Date().getTime() - startTime) / 1000L;
                    } while (!retry && this.getPid() != null && deltaTime < (long)stopMaxWait);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            } while (retry);
            if (this.getPid() == null) {
                log.warn("Server stopped.");
            } else {
                log.info("No answer from server, try to kill process {}...", (Object)this.pid);
                this.processManager.kill(this.nuxeoProcess, this.pid);
                if (this.getPid() == null) {
                    log.warn("Server forcibly stopped.");
                }
            }
        }
        catch (IOException e) {
            log.error("Could not manage process!", (Throwable)e);
        }
    }

    protected abstract void setServerStopCommand(List<String> var1);

    private String getPid() throws IOException {
        this.pid = this.processManager.findPid(this.processRegex);
        log.debug("regexp: {} pid: {}", (Object)this.processRegex, (Object)this.pid);
        return this.pid;
    }

    public void configure() throws ConfigurationException {
        try {
            this.checkNoRunningServer();
            this.configurationGenerator.checkJavaVersion();
            this.configurationGenerator.run();
            this.overrideJavaTmpDir = Boolean.parseBoolean(this.configurationGenerator.getUserConfig().getProperty(OVERRIDE_JAVA_TMPDIR_PARAM, "true"));
        }
        catch (ConfigurationException e) {
            this.errorValue = 6;
            throw e;
        }
    }

    private String getDefaultMaxWait() {
        return START_MAX_WAIT_DEFAULT;
    }

    public String status() {
        try {
            if (this.processManager instanceof PureJavaProcessManager) {
                this.status = 4;
                return "Can't check server status on your OS.";
            }
            if (this.getPid() == null) {
                this.status = 3;
                return "Server is not running.";
            }
            this.status = 0;
            return "Server is running with process ID " + this.getPid() + ".";
        }
        catch (IOException e) {
            this.status = 4;
            return "Could not check existing process (" + e.getMessage() + ").";
        }
    }

    public int getStatus() {
        return this.status;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public static NuxeoLauncher createLauncher(String[] args) throws ConfigurationException, ParseException, IOException, PackageException {
        NuxeoLauncher launcher;
        CommandLine cmdLine = NuxeoLauncher.parseOptions(args);
        ConfigurationGenerator cg = new ConfigurationGenerator(quiet, debug);
        if (cmdLine.hasOption(OPTION_HIDE_DEPRECATION)) {
            cg.hideDeprecationWarnings(true);
        }
        if (cg.isJetty) {
            launcher = new NuxeoJettyLauncher(cg);
        } else if (cg.isTomcat) {
            launcher = new NuxeoTomcatLauncher(cg);
        } else {
            throw new ConfigurationException("Unknown server!");
        }
        launcher.connectBroker = new ConnectBroker(launcher.configurationGenerator.getEnv());
        launcher.setArgs(cmdLine);
        launcher.initConnectBroker();
        return launcher;
    }

    private void setArgs(CommandLine cmdLine) throws ConfigurationException {
        this.cmdLine = cmdLine;
        this.extractCommandAndParams(cmdLine.getArgs());
        if (cmdLine.hasOption(OPTION_GUI)) {
            this.useGui = Boolean.parseBoolean(ConnectBroker.parseAnswer(cmdLine.getOptionValue(OPTION_GUI)));
            log.debug("GUI: {} -> {}", () -> cmdLine.getOptionValue(OPTION_GUI), () -> this.useGui);
        } else if (OPTION_GUI.equalsIgnoreCase(this.command)) {
            this.useGui = true;
            this.extractCommandAndParams(this.params);
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.useGui = true;
            log.debug("GUI: option not set - platform is Windows -> start GUI");
        } else {
            this.useGui = false;
            log.debug("GUI: option not set - platform is not Windows -> do not start GUI");
        }
        if (cmdLine.hasOption(OPTION_XML)) {
            this.setXMLOutput();
        }
        if (cmdLine.hasOption(OPTION_JSON)) {
            this.setJSONOutput();
        }
        if (cmdLine.hasOption(OPTION_CLID)) {
            try {
                this.getConnectBroker().setCLID(cmdLine.getOptionValue(OPTION_CLID));
            }
            catch (LogicalInstanceIdentifier.NoCLID e) {
                throw new ConfigurationException(e);
            }
        }
        if (cmdLine.hasOption(OPTION_IGNORE_MISSING)) {
            this.ignoreMissing = true;
        }
    }

    private void extractCommandAndParams(String[] args) {
        if (args.length > 0) {
            this.command = args[0];
            log.debug("Launcher command: {}", (Object)this.command);
            if (args.length > 1) {
                this.params = Arrays.copyOfRange(args, 1, args.length);
                log.debug("Command parameters: {}", () -> ArrayUtils.toString(this.params));
            } else {
                this.params = new String[0];
            }
        } else {
            this.command = null;
        }
    }

    protected static void setQuiet() {
        quiet = true;
        Log4JHelper.setLevel(new String[]{""}, Level.WARN, true);
    }

    protected static void setDebug(String[] loggerNames) {
        debug = true;
        if (loggerNames == null) {
            loggerNames = new String[]{"org.nuxeo.launcher"};
        }
        Log4JHelper.setLevel(loggerNames, Level.DEBUG, true);
    }

    protected static void setStrict(boolean isStrict) {
        strict = isStrict;
    }

    protected void setXMLOutput() {
        this.xmlOutput = true;
    }

    protected void setJSONOutput() {
        this.jsonOutput = true;
        this.setXMLOutput();
    }

    public static void printShortHelp() {
        System.out.println();
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("USAGE\n");
        help.setOptionComparator(null);
        help.setWidth(1000);
        help.printHelp(OPTION_HELP_USAGE, "OPTIONS", options, null);
        System.out.println(OPTION_HELP_DESC_COMMANDS);
    }

    public static void printLongHelp() {
        System.out.println();
        HelpFormatter help = new HelpFormatter();
        help.setSyntaxPrefix("USAGE\n");
        help.setOptionComparator(null);
        help.setWidth(1000);
        help.printHelp(OPTION_HELP_USAGE, OPTION_HELP_HEADER, options, null);
        System.out.println(OPTION_HELP_DESC_ENV);
        System.out.println(OPTION_HELP_DESC_COMMANDS);
        System.out.println(OPTION_HELP_FOOTER);
    }

    public boolean isRunning() {
        if (this.nuxeoProcess != null) {
            try {
                this.nuxeoProcess.exitValue();
                this.nuxeoProcess = null;
            }
            catch (IllegalThreadStateException exception) {
                return true;
            }
        }
        try {
            return this.getPid() != null;
        }
        catch (IOException e) {
            log.error(e);
            return false;
        }
    }

    public InstanceInfo getInfo() {
        return this.info;
    }

    public boolean isStarted() {
        boolean isStarted;
        try {
            isStarted = this.isRunning() && this.statusServletClient.isStarted();
        }
        catch (SocketTimeoutException e) {
            isStarted = false;
        }
        return isStarted;
    }

    public File getLogFile() {
        return new File(this.configurationGenerator.getLogDir(), "server.log");
    }

    public String getURL() {
        return this.configurationGenerator.getUserConfig().getProperty("nuxeo.url");
    }

    protected void initConnectBroker() {
        if (this.cmdLine.hasOption(OPTION_ACCEPT)) {
            this.connectBroker.setAccept(this.cmdLine.getOptionValue(OPTION_ACCEPT));
        }
        if (this.cmdLine.hasOption(OPTION_RELAX)) {
            this.connectBroker.setRelax(this.cmdLine.getOptionValue(OPTION_RELAX));
        }
        if (this.cmdLine.hasOption(OPTION_SNAPSHOT)) {
            this.connectBroker.setAllowSNAPSHOT(true);
        }
        List<CommandInfo> csetCommands = this.cset.commands;
        this.cset = this.connectBroker.getCommandSet();
        this.cset.commands.addAll(0, csetCommands);
        try {
            this.clid = this.connectBroker.getCLID();
        }
        catch (LogicalInstanceIdentifier.NoCLID noCLID) {
            // empty catch block
        }
        this.info = this.configurationGenerator.getServerConfigurator().getInfo(this.clid, this.connectBroker.getPkgList());
        if (new Version(this.info.distribution.version).isSnapshot()) {
            this.connectBroker.setAllowSNAPSHOT(true);
        }
        this.connectBroker.setPendingFile(this.configurationGenerator.getInstallFile().toPath());
    }

    protected ConnectBroker getConnectBroker() {
        return this.connectBroker;
    }

    protected ConnectRegistrationBroker getConnectRegistrationBroker() {
        if (this.connectRegistrationBroker == null) {
            this.getConnectBroker();
            this.connectRegistrationBroker = new ConnectRegistrationBroker();
        }
        return this.connectRegistrationBroker;
    }

    protected void pkgList() {
        this.getConnectBroker().listPending(this.configurationGenerator.getInstallFile());
        this.getConnectBroker().pkgList();
    }

    protected void pkgListAll() {
        this.getConnectBroker().listPending(this.configurationGenerator.getInstallFile());
        this.getConnectBroker().pkgListAll();
    }

    protected boolean pkgAdd(String[] pkgNames) {
        boolean cmdOK = this.getConnectBroker().pkgAdd(Arrays.asList(pkgNames), this.ignoreMissing);
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgInstall(String[] pkgIDs) {
        boolean cmdOK = true;
        if (this.configurationGenerator.isInstallInProgress()) {
            cmdOK = this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, !this.cmdLine.hasOption(OPTION_NODEPS), this.ignoreMissing);
        }
        boolean bl = cmdOK = cmdOK && this.getConnectBroker().pkgInstall(Arrays.asList(pkgIDs), this.ignoreMissing);
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgUninstall(String[] pkgIDs) {
        boolean cmdOK = this.getConnectBroker().pkgUninstall(Arrays.asList(pkgIDs));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgRemove(String[] pkgIDs) {
        boolean cmdOK = this.getConnectBroker().pkgRemove(Arrays.asList(pkgIDs));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgReset() {
        boolean cmdOK = this.getConnectBroker().pkgReset();
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected void printInstanceXMLOutput(InstanceInfo instance) {
        try {
            this.printInstanceXMLOutput(instance, System.out);
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            log.error("Output serialization failed: {}", supplierArray);
            log.debug(e, e);
            this.errorValue = 7;
        }
    }

    protected void printInstanceXMLOutput(InstanceInfo instance, OutputStream out) throws JAXBException, XMLStreamException, FactoryConfigurationError {
        JAXBContext jaxbContext = JAXBContext.newInstance(InstanceInfo.class, DistributionInfo.class, PackageInfo.class, ConfigurationInfo.class, KeyValueInfo.class);
        this.printXMLOutput(jaxbContext, instance, out);
    }

    protected void showConfig() {
        log.info("***** Nuxeo instance configuration *****");
        log.info("NUXEO_CONF: {}", (Object)this.info.NUXEO_CONF);
        log.info("NUXEO_HOME: {}", (Object)this.info.NUXEO_HOME);
        if (this.info.clid != null) {
            log.info("Instance CLID: {}", (Object)this.info.clid);
        }
        log.info("** Distribution");
        log.info("- name: {}", (Object)this.info.distribution.name);
        log.info("- server: {}", (Object)this.info.distribution.server);
        log.info("- version: {}", (Object)this.info.distribution.version);
        log.info("- date: {}", (Object)this.info.distribution.date);
        log.info("- packaging: {}", (Object)this.info.distribution.packaging);
        log.info("** Packages:");
        for (PackageInfo pkg : this.info.packages) {
            log.info("- {} (version: {} - id: {}} - state: {})", (Object)pkg.name, (Object)pkg.version, (Object)pkg.id, (Object)pkg.state.getLabel());
        }
        log.info("** Templates:");
        log.info("Database template: {}", (Object)this.info.config.dbtemplate);
        for (String template : this.info.config.pkgtemplates) {
            log.info("Package template: {}", (Object)template);
        }
        for (String template : this.info.config.usertemplates) {
            log.info("User template: {}", (Object)template);
        }
        for (String template : this.info.config.basetemplates) {
            log.info("Base template: {}", (Object)template);
        }
        log.info("** Settings from nuxeo.conf:");
        for (KeyValueInfo keyval : this.info.config.keyvals) {
            log.info("{}={}", (Object)keyval.key, (Object)keyval.value);
        }
        log.info("****************************************");
        if (this.xmlOutput) {
            this.printInstanceXMLOutput(this.info);
        }
    }

    protected boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove) {
        boolean cmdOK = true;
        if (this.configurationGenerator.isInstallInProgress()) {
            cmdOK = this.getConnectBroker().executePending(this.configurationGenerator.getInstallFile(), true, true, this.ignoreMissing);
        }
        boolean bl = cmdOK = cmdOK && this.getConnectBroker().pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove, true, this.ignoreMissing);
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgRefreshCache() {
        this.getConnectBroker().refreshCache();
        return true;
    }

    protected boolean pkgInit() {
        log.warn("The 'mp-init' command is deprecated, no more Nuxeo Packages locally available in the distribution.");
        return true;
    }

    protected boolean pkgPurge() throws PackageException {
        return this.getConnectBroker().pkgPurge();
    }

    protected boolean pkgHotfix() {
        return this.getConnectBroker().pkgHotfix();
    }

    protected boolean pkgUpgrade() {
        return this.getConnectBroker().pkgUpgrade();
    }

    protected boolean pkgCompoundRequest(List<String> request) {
        ArrayList<String> add = new ArrayList<String>();
        ArrayList<String> install = new ArrayList<String>();
        ArrayList<String> uninstall = new ArrayList<String>();
        for (String param : request) {
            for (String subparam : param.split("[ ,]")) {
                if (subparam.charAt(0) == '-') {
                    uninstall.add(subparam.substring(1));
                    continue;
                }
                if (subparam.charAt(0) == '+') {
                    install.add(subparam.substring(1));
                    continue;
                }
                add.add(subparam);
            }
        }
        return this.pkgRequest(add, install, uninstall, null);
    }

    protected boolean pkgSetRequest(List<String> request, boolean nodeps) {
        boolean cmdOK = nodeps ? this.getConnectBroker().pkgSet(request, this.ignoreMissing) : this.getConnectBroker().pkgRequest(null, request, null, null, false, this.ignoreMissing);
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    protected boolean pkgShow(String[] packages) {
        boolean cmdOK = this.getConnectBroker().pkgShow(Arrays.asList(packages));
        if (!cmdOK) {
            this.errorValue = 1;
        }
        return cmdOK;
    }

    static {
        if (System.getProperty("nuxeo.log.dir") == null) {
            System.setProperty("nuxeo.log.dir", ".");
        }
        log = LogManager.getLogger(NuxeoLauncher.class);
        options = NuxeoLauncher.initParserOptions();
        COMMANDS_NO_GUI = new String[]{"configure", "mp-purge", "mp-add", "mp-install", "mp-uninstall", "mp-request", "mp-remove", "mp-hotfix", "mp-upgrade", "mp-reset", "mp-list", "mp-listall", "mp-update", "status", "showconf", "mp-show", "mp-set", "config", OPTION_ENCRYPT, "decrypt", OPTION_HELP, "register", "register-trial"};
        COMMANDS_NO_RUNNING_SERVER = new String[]{"mp-purge", "mp-add", "mp-install", "mp-uninstall", "mp-request", "mp-remove", "mp-hotfix", "mp-upgrade", "mp-reset", "mp-update", "mp-set"};
        OPTION_HELP_DESC_ENV = "\nENVIRONMENT VARIABLES\n        NUXEO_HOME\t\tPath to server root directory.\n        NUXEO_CONF\t\tPath to {{nuxeo.conf}} file.\n        PATH\n\tJAVA\t\t\tPath to the {{java}} executable.\n        JAVA_HOME\t\tPath to the Java home directory. Can also be defined in {{nuxeo.conf}}.\n        JAVA_OPTS\t\tOptional values passed to the JVM. Can also be defined in {{nuxeo.conf}}.\n        REQUIRED_JAVA_VERSION\tNuxeo requirement on Java version.\n\nJAVA USAGE\n" + String.format("        java [-D%s=\"JVM options\"] [-D%s=\"/path/to/nuxeo\"] [-D%s=\"/path/to/nuxeo.conf\"] [-Djvmcheck=nofail] -jar \"path/to/nuxeo-launcher.jar\" \\\n        \t[options] <command> [command parameters]\n\n", JAVA_OPTS_PROPERTY, "nuxeo.home", "nuxeo.conf") + String.format("        %s\tParameters for the server JVM (default are %s).\n", JAVA_OPTS_PROPERTY, JAVA_OPTS_DEFAULT) + String.format("        %s\t\tNuxeo server root path (default is parent of called script).\n", "nuxeo.home") + String.format("        %s\t\tPath to {{%1$s}} file (default is \"$NUXEO_HOME/bin/%1$s\").\n", "nuxeo.conf") + "        jvmcheck\t\tIf set to \"nofail\", ignore JVM version validation errors.\n";
        quiet = false;
        debug = false;
        strict = true;
    }

    protected class ShutdownThread
    extends Thread {
        private NuxeoLauncher launcher;

        public ShutdownThread(NuxeoLauncher launcher) {
            this.launcher = launcher;
        }

        @Override
        public void run() {
            log.debug("Shutting down...");
            if (this.launcher.isRunning()) {
                this.launcher.stop();
            }
            log.debug("Shutdown complete.");
        }
    }
}

