/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.deploy.Contribution;
import org.nuxeo.runtime.deploy.DependencyTree;
import org.nuxeo.runtime.deploy.ExtensibleContribution;
import org.nuxeo.runtime.deploy.ManagedComponent;

public class ContributionManager
extends DependencyTree<String, Contribution> {
    private static final Log log = LogFactory.getLog(ContributionManager.class);
    private final ManagedComponent component;

    public ContributionManager(ManagedComponent component) {
        this.component = component;
    }

    public ManagedComponent getComponent() {
        return this.component;
    }

    public void registerContribution(Contribution contrib) {
        Collection<String> cdeps;
        String baseId = null;
        if (contrib instanceof ExtensibleContribution) {
            ExtensibleContribution c = (ExtensibleContribution)contrib;
            baseId = c.getBaseContributionId();
        }
        ArrayList<String> deps = new ArrayList<String>();
        if (baseId != null) {
            deps.add(baseId);
        }
        if ((cdeps = contrib.getDependencies()) != null) {
            deps.addAll(cdeps);
        }
        this.add(contrib.getContributionId(), contrib, deps);
    }

    public void unregisterContribution(Contribution contrib) {
        this.remove(contrib.getContributionId());
    }

    @Override
    protected void resolved(DependencyTree.Entry<String, Contribution> entry) {
        Contribution contrib = entry.get();
        contrib.resolve(this);
        try {
            contrib.install(this.component);
        }
        catch (RuntimeException e) {
            log.error(e, e);
        }
    }

    @Override
    protected void unresolved(DependencyTree.Entry<String, Contribution> entry) {
        Contribution contrib = entry.get();
        try {
            contrib.uninstall(this.component);
        }
        catch (RuntimeException e) {
            log.error(e, e);
        }
        contrib.unresolve(this);
    }
}

