/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IteratorInt;

public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected boolean hasBeenReduced = false;
    protected long numberOfReductions = 0L;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected VecInt[] byLevel;
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.ConflictMap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictMap(cpb, level);
    }

    ConflictMap(PBConstr cpb, int level) {
        super(cpb);
        this.voc = cpb.getVocabulary();
        this.currentLevel = level;
        this.initStructures();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        this.byLevel = new VecInt[ConflictMap.levelToIndex(this.currentLevel) + 1];
        int i = 0;
        while (i < this.size()) {
            int index;
            int ilit = this.weightedLits.getLit(i);
            int litLevel = this.voc.getLevel(ilit);
            BigInteger tmp = this.weightedLits.getCoef(i);
            if (!(tmp.signum() <= 0 || this.voc.isFalsified(ilit) && litLevel != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(tmp);
            }
            if (this.byLevel[index = ConflictMap.levelToIndex(litLevel)] == null) {
                this.byLevel[index] = new VecInt();
            }
            this.byLevel[index].push(ilit);
            ++i;
        }
    }

    private static final int levelToIndex(int level) {
        return level + 1;
    }

    private static final int indexToLevel(int indLevel) {
        return indLevel - 1;
    }

    public BigInteger resolve(PBConstr cpb, int litImplied, VarActivityListener val) {
        if (!$assertionsDisabled && litImplied <= 1) {
            throw new AssertionError();
        }
        int nLitImplied = litImplied ^ 1;
        if (cpb == null || !this.weightedLits.containsKey(nLitImplied)) {
            int litLevel = ConflictMap.levelToIndex(this.voc.getLevel(litImplied));
            int lit = 0;
            if (this.byLevel[litLevel] != null) {
                if (this.byLevel[litLevel].contains(litImplied)) {
                    lit = litImplied;
                    if (!$assertionsDisabled && !this.weightedLits.containsKey(litImplied)) {
                        throw new AssertionError();
                    }
                } else if (this.byLevel[litLevel].contains(nLitImplied)) {
                    lit = nLitImplied;
                    if (!$assertionsDisabled && !this.weightedLits.containsKey(nLitImplied)) {
                        throw new AssertionError();
                    }
                }
            }
            if (lit > 0) {
                this.byLevel[litLevel].remove(lit);
                if (this.byLevel[0] == null) {
                    this.byLevel[0] = new VecInt();
                }
                this.byLevel[0].push(lit);
            }
            return this.degree;
        }
        if (!$assertionsDisabled && this.slackConflict().signum() > 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.degree.signum() < 0) {
            throw new AssertionError();
        }
        BigInteger[] coefsCons = null;
        BigInteger degreeCons = cpb.getDegree();
        int ind = 0;
        while (cpb.get(ind) != litImplied) {
            ++ind;
        }
        if (!$assertionsDisabled && cpb.get(ind) != litImplied) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cpb.getCoef(ind) == BigInteger.ZERO) {
            throw new AssertionError();
        }
        if (cpb.getCoef(ind).equals(BigInteger.ONE)) {
            this.coefMultCons = this.weightedLits.get(nLitImplied);
            this.coefMult = BigInteger.ONE;
            degreeCons = degreeCons.multiply(this.coefMultCons);
        } else {
            if (this.weightedLits.get(nLitImplied).equals(BigInteger.ONE)) {
                this.coefMult = cpb.getCoef(ind);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                IWatchPb wpb = (IWatchPb)cpb;
                coefsCons = wpb.getCoefs();
                if (!$assertionsDisabled && !ConflictMap.positiveCoefs(coefsCons)) {
                    throw new AssertionError();
                }
                degreeCons = this.reduceUntilConflict(litImplied, ind, coefsCons, wpb);
                degreeCons = degreeCons.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            if (!this.coefMult.equals(BigInteger.ONE)) {
                int i = 0;
                while (i < this.size()) {
                    this.changeCoef(i, this.weightedLits.getCoef(i).multiply(this.coefMult));
                    ++i;
                }
            }
        }
        if (!$assertionsDisabled && this.slackConflict().signum() > 0) {
            throw new AssertionError();
        }
        this.degree = this.cuttingPlane(cpb, degreeCons, coefsCons, this.coefMultCons, val);
        if (!$assertionsDisabled && this.weightedLits.containsKey(litImplied)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.weightedLits.containsKey(nLitImplied)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getLevelByLevel(litImplied) != -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getLevelByLevel(nLitImplied) != -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.slackConflict().signum() > 0) {
            throw new AssertionError();
        }
        this.degree = this.saturation();
        if (!$assertionsDisabled && this.slackConflict().signum() > 0) {
            throw new AssertionError();
        }
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, IWatchPb wpb) {
        BigInteger slackIndex;
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackConflict = this.slackConflict();
        BigInteger reducedDegree = wpb.getDegree();
        BigInteger previousCoefLitImplied = BigInteger.ZERO;
        BigInteger coefLitImplied = this.weightedLits.get(litImplied ^ 1);
        do {
            if (slackResolve.signum() >= 0) {
                if (!$assertionsDisabled && slackThis.signum() <= 0) {
                    throw new AssertionError();
                }
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree);
                if (!($assertionsDisabled || tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0)) {
                    throw new AssertionError();
                }
                reducedDegree = tmp;
            }
            if (!$assertionsDisabled && this.weightedLits.get(litImplied ^ 1).signum() <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && reducedCoefs[ind].signum() <= 0) {
                throw new AssertionError();
            }
            if (!reducedCoefs[ind].equals(previousCoefLitImplied)) {
                if (!$assertionsDisabled && !coefLitImplied.equals(this.weightedLits.get(litImplied ^ 1))) {
                    throw new AssertionError();
                }
                BigInteger ppcm = ConflictMap.ppcm(reducedCoefs[ind], coefLitImplied);
                if (!$assertionsDisabled && ppcm.signum() <= 0) {
                    throw new AssertionError();
                }
                this.coefMult = ppcm.divide(coefLitImplied);
                this.coefMultCons = ppcm.divide(reducedCoefs[ind]);
                if (!$assertionsDisabled && this.coefMultCons.signum() <= 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.coefMult.signum() <= 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.coefMult.multiply(coefLitImplied).equals(this.coefMultCons.multiply(reducedCoefs[ind]))) {
                    throw new AssertionError();
                }
                previousCoefLitImplied = reducedCoefs[ind];
            }
            slackThis = wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons);
            if (!$assertionsDisabled && !slackConflict.equals(this.slackConflict())) {
                throw new AssertionError();
            }
            slackIndex = slackConflict.multiply(this.coefMult);
            if (!$assertionsDisabled && slackIndex.signum() > 0) {
                throw new AssertionError();
            }
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0);
        if (!$assertionsDisabled && !this.coefMult.multiply(this.weightedLits.get(litImplied ^ 1)).equals(this.coefMultCons.multiply(reducedCoefs[ind]))) {
            throw new AssertionError();
        }
        return reducedDegree;
    }

    public BigInteger slackConflict() {
        BigInteger poss = BigInteger.ZERO;
        int i = 0;
        while (i < this.size()) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            if (tmp.signum() != 0 && !this.voc.isFalsified(this.weightedLits.getLit(i))) {
                if (!$assertionsDisabled && tmp.signum() <= 0) {
                    throw new AssertionError();
                }
                poss = poss.add(tmp);
            }
            ++i;
        }
        return poss.subtract(this.degree);
    }

    public boolean oldIsAssertive(int dl) {
        BigInteger slack = this.computeSlack(dl).subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            int lit = this.weightedLits.getLit(i);
            if (tmp.signum() > 0 && (this.voc.isUnassigned(lit) || this.voc.getLevel(lit) >= dl) && slack.compareTo(tmp) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BigInteger computeSlack(int dl) {
        BigInteger slack = BigInteger.ZERO;
        int i = 0;
        while (i < this.size()) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            int lit = this.weightedLits.getLit(i);
            if (!(tmp.signum() <= 0 || this.voc.isFalsified(lit) && this.voc.getLevel(lit) < dl)) {
                slack = slack.add(tmp);
            }
            ++i;
        }
        return slack;
    }

    public boolean isAssertive(int dl) {
        if (!$assertionsDisabled && dl > this.currentLevel) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dl > this.currentLevel) {
            throw new AssertionError();
        }
        this.currentLevel = dl;
        BigInteger slack = this.currentSlack.subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(slack);
    }

    private boolean isImplyingLiteral(BigInteger slack) {
        int level;
        int lit;
        int unassigned = ConflictMap.levelToIndex(-1);
        if (this.byLevel[unassigned] != null) {
            IteratorInt iterator = this.byLevel[unassigned].iterator();
            while (iterator.hasNext()) {
                lit = iterator.next();
                if (slack.compareTo(this.weightedLits.get(lit)) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.allLits.get(lit);
                return true;
            }
        }
        if (this.byLevel[level = ConflictMap.levelToIndex(this.currentLevel)] != null) {
            IteratorInt iterator = this.byLevel[level].iterator();
            while (iterator.hasNext()) {
                lit = iterator.next();
                BigInteger tmp = this.weightedLits.get(lit);
                if (tmp == null || slack.compareTo(tmp) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.allLits.get(lit);
                return true;
            }
        }
        return false;
    }

    private boolean isImplyingLiteralOrdered(int dl, BigInteger slack) {
        int i = 0;
        while (i < this.size()) {
            int ilit = this.weightedLits.getLit(i);
            int litLevel = this.voc.getLevel(ilit);
            if ((litLevel >= dl || this.voc.isUnassigned(ilit)) && slack.compareTo(this.weightedLits.getCoef(i)) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    public BigInteger reduceInConstraint(IWatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
        if (!$assertionsDisabled && degreeBis.compareTo(BigInteger.ONE) <= 0) {
            throw new AssertionError();
        }
        int lit = -1;
        int ind = 0;
        while (ind < wpb.size() && lit == -1) {
            if (coefsBis[ind].signum() != 0 && this.voc.isUnassigned(wpb.get(ind))) {
                if (!$assertionsDisabled && coefsBis[ind].compareTo(degreeBis) >= 0) {
                    throw new AssertionError();
                }
                lit = ind;
            }
            ++ind;
        }
        if (lit == -1) {
            ind = 0;
            while (ind < wpb.size() && lit == -1) {
                if (coefsBis[ind].signum() != 0 && this.voc.isSatisfied(wpb.get(ind)) && ind != indLitImplied) {
                    lit = ind;
                }
                ++ind;
            }
        }
        if (!$assertionsDisabled && lit == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && lit == indLitImplied) {
            throw new AssertionError();
        }
        BigInteger degUpdate = degreeBis.subtract(coefsBis[lit]);
        coefsBis[lit] = BigInteger.ZERO;
        degUpdate = ConflictMap.saturation(coefsBis, degUpdate);
        if (!$assertionsDisabled && coefsBis[indLitImplied].signum() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && degreeBis.compareTo(degUpdate) <= 0) {
            throw new AssertionError();
        }
        return degUpdate;
    }

    static BigInteger saturation(BigInteger[] coefs, BigInteger degree) {
        if (!$assertionsDisabled && degree.signum() <= 0) {
            throw new AssertionError();
        }
        BigInteger minimum = degree;
        int i = 0;
        while (i < coefs.length) {
            if (coefs[i].signum() > 0) {
                minimum = minimum.min(coefs[i]);
            }
            coefs[i] = degree.min(coefs[i]);
            ++i;
        }
        if (minimum.equals(degree) && !degree.equals(BigInteger.ONE)) {
            degree = BigInteger.ONE;
            i = 0;
            while (i < coefs.length) {
                if (coefs[i].signum() > 0) {
                    coefs[i] = degree;
                }
                ++i;
            }
        }
        return degree;
    }

    private static boolean positiveCoefs(BigInteger[] coefsCons) {
        int i = 0;
        while (i < coefsCons.length) {
            if (coefsCons[i].signum() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getBacktrackLevel(int maxLevel) {
        int indStop = ConflictMap.levelToIndex(maxLevel) - 1;
        int indStart = ConflictMap.levelToIndex(0);
        BigInteger slack = this.computeSlack(0).subtract(this.degree);
        int previous = 0;
        int indLevel = indStart;
        while (indLevel <= indStop) {
            if (this.byLevel[indLevel] != null) {
                int level = ConflictMap.indexToLevel(indLevel);
                if (!$assertionsDisabled && !this.computeSlack(level).subtract(this.degree).equals(slack)) {
                    throw new AssertionError();
                }
                if (this.isImplyingLiteralOrdered(level, slack)) break;
                VecInt lits = this.byLevel[indLevel];
                IteratorInt iterator = lits.iterator();
                while (iterator.hasNext()) {
                    int lit = iterator.next();
                    if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) != ConflictMap.indexToLevel(indLevel)) continue;
                    slack = slack.subtract(this.weightedLits.get(lit));
                }
                if (!lits.isEmpty()) {
                    previous = level;
                }
            }
            ++indLevel;
        }
        if (!$assertionsDisabled && previous != this.oldGetBacktrackLevel(maxLevel)) {
            throw new AssertionError();
        }
        return previous;
    }

    public int oldGetBacktrackLevel(int maxLevel) {
        int litLevel;
        int borneMax = maxLevel;
        if (!$assertionsDisabled && !this.oldIsAssertive(borneMax)) {
            throw new AssertionError();
        }
        int borneMin = -1;
        int i = 0;
        while (i < this.size()) {
            litLevel = this.voc.getLevel(this.weightedLits.getLit(i));
            if (litLevel < borneMax && litLevel > borneMin && this.oldIsAssertive(litLevel)) {
                borneMax = litLevel;
            }
            ++i;
        }
        int retour = 0;
        int i2 = 0;
        while (i2 < this.size()) {
            litLevel = this.voc.getLevel(this.weightedLits.getLit(i2));
            if (litLevel > retour && litLevel < borneMax) {
                retour = litLevel;
            }
            ++i2;
        }
        return retour;
    }

    public void updateSlack(int level) {
        int dl = ConflictMap.levelToIndex(level);
        if (this.byLevel[dl] != null) {
            IteratorInt iterator = this.byLevel[dl].iterator();
            while (iterator.hasNext()) {
                int lit = iterator.next();
                if (!this.voc.isFalsified(lit)) continue;
                this.currentSlack = this.currentSlack.add(this.weightedLits.get(lit));
            }
        }
    }

    void increaseCoef(int lit, BigInteger incCoef) {
        if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(incCoef);
        }
        if (!$assertionsDisabled && !this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(lit))].contains(lit)) {
            throw new AssertionError();
        }
        super.increaseCoef(lit, incCoef);
    }

    void decreaseCoef(int lit, BigInteger decCoef) {
        if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(decCoef);
        }
        if (!$assertionsDisabled && !this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(lit))].contains(lit)) {
            throw new AssertionError();
        }
        super.decreaseCoef(lit, decCoef);
    }

    void setCoef(int lit, BigInteger newValue) {
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            if (this.weightedLits.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        if (!this.weightedLits.containsKey(lit)) {
            if (this.byLevel[indLitLevel] == null) {
                this.byLevel[indLitLevel] = new VecInt();
            }
            this.byLevel[indLitLevel].push(lit);
        }
        if (!$assertionsDisabled && this.byLevel[indLitLevel] == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.byLevel[indLitLevel].contains(lit)) {
            throw new AssertionError();
        }
        super.setCoef(lit, newValue);
    }

    void changeCoef(int indLit, BigInteger newValue) {
        int lit = this.weightedLits.getLit(indLit);
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            if (this.weightedLits.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        if (!$assertionsDisabled && !this.weightedLits.containsKey(lit)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.byLevel[indLitLevel] == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.byLevel[indLitLevel].contains(lit)) {
            throw new AssertionError();
        }
        super.changeCoef(indLit, newValue);
    }

    void removeCoef(int lit) {
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        if (!$assertionsDisabled && indLitLevel >= this.byLevel.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.byLevel[indLitLevel] == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.byLevel[indLitLevel].contains(lit)) {
            throw new AssertionError();
        }
        this.byLevel[indLitLevel].remove(lit);
        super.removeCoef(lit);
    }

    private int getLevelByLevel(int lit) {
        int i = 0;
        while (i < this.byLevel.length) {
            if (this.byLevel[i] != null && this.byLevel[i].contains(lit)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean slackIsCorrect(int dl) {
        return this.currentSlack.equals(this.computeSlack(dl));
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            int lit = this.weightedLits.getLit(i);
            stb.append(this.weightedLits.getCoef(i));
            stb.append(".");
            stb.append(Lits.toString(lit));
            stb.append(" ");
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("@");
            stb.append(this.voc.getLevel(lit));
            stb.append("]");
            ++i;
        }
        return String.valueOf(stb.toString()) + " >= " + this.degree;
    }

    public boolean hasBeenReduced() {
        return this.hasBeenReduced;
    }

    public long getNumberOfReductions() {
        return this.numberOfReductions;
    }
}

