/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLongCP;
import org.sat4j.specs.ContradictionException;

public final class MaxWatchPbLongCP
extends WatchPbLongCP {
    private static final long serialVersionUID = 1L;
    private long watchCumul = 0L;
    private final Map<Integer, Long> litToCoeffs;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MaxWatchPbLongCP");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private MaxWatchPbLongCP(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            int i = 0;
            while (i < this.coefs.length) {
                this.litToCoeffs.put(new Integer(this.lits[i]), new Long(this.coefs[i]));
                ++i;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPbLongCP(ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) {
        super(lits, coefs, degree);
        this.voc = voc;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(coefs.length);
            int i = 0;
            while (i < coefs.length) {
                this.litToCoeffs.put(new Integer(lits[i]), new Long(this.coefs[i]));
                ++i;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul != 0L) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[i] ^ 1).push(this);
                    this.voc.watch(this.lits[i] ^ 1, this);
                }
            } else {
                this.voc.watch(this.lits[i] ^ 1, this);
                this.watchCumul += this.coefs[i];
            }
            ++i;
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        if (!this.learnt && this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        int ind = 0;
        while (ind < this.coefs.length && this.watchCumul - this.coefs[ind] < this.degree) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++ind;
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        long coefP;
        this.voc.watch(p, this);
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError((Object)(this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt));
        }
        if (this.litToCoeffs == null) {
            int indiceP = 0;
            while ((this.lits[indiceP] ^ 1) != p) {
                ++indiceP;
            }
            coefP = this.coefs[indiceP];
        } else {
            coefP = this.litToCoeffs.get(new Integer(p ^ 1));
        }
        long newcumul = this.watchCumul - coefP;
        if (newcumul < this.degree) {
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        this.voc.undos(p).push(this);
        this.watchCumul = newcumul;
        int ind = 0;
        long limit = this.watchCumul - this.degree;
        while (ind < this.coefs.length && limit < this.coefs[ind]) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], this)) {
                if (!$assertionsDisabled && this.isSatisfiable()) {
                    throw new AssertionError();
                }
                return false;
            }
            ++ind;
        }
        if (!$assertionsDisabled && !this.learnt && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener upl) {
        int i = 0;
        while (i < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[i])) {
                this.voc.watches(this.lits[i] ^ 1).remove(this);
            }
            if (this.voc.isSatisfied(this.lits[i])) {
                upl.unset(this.lits[i]);
            }
            ++i;
        }
    }

    public void undo(int p) {
        long coefP;
        if (this.litToCoeffs == null) {
            int indiceP = 0;
            while ((this.lits[indiceP] ^ 1) != p) {
                ++indiceP;
            }
            coefP = this.coefs[indiceP];
        } else {
            coefP = this.litToCoeffs.get(new Integer(p ^ 1));
        }
        this.watchCumul += coefP;
    }

    public static MaxWatchPbLongCP normalizedMaxWatchPbNew(UnitPropagationListener s, ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        MaxWatchPbLongCP outclause = new MaxWatchPbLongCP(voc, lits, coefs, degree);
        if (outclause.degree <= 0L) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    public static WatchPbLongCP normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new MaxWatchPbLongCP(voc, mpb);
    }
}

