/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.card.MinWatchCard;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.UnitClausesPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public final class MinWatchCardPB
extends MinWatchCard
implements PBConstr {
    private static final long serialVersionUID = 1L;
    private final BigInteger bigDegree = BigInteger.valueOf(this.degree);
    private boolean learnt = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MinWatchCardPB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MinWatchCardPB(ILits voc, IVecInt ps, boolean moreThan, int degree) {
        super(voc, ps, moreThan, degree);
    }

    public MinWatchCardPB(ILits voc, IVecInt ps, int degree) {
        super(voc, ps, degree);
    }

    public BigInteger getCoef(int literal) {
        return BigInteger.ONE;
    }

    public BigInteger getDegree() {
        return this.bigDegree;
    }

    public BigInteger[] getCoefs() {
        BigInteger[] tmp = new BigInteger[this.size()];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = BigInteger.ONE;
            ++i;
        }
        return tmp;
    }

    public static PBConstr normalizedMinWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, int degree) throws ContradictionException {
        return MinWatchCardPB.minWatchCardPBNew(s, voc, ps, true, degree, true);
    }

    public static PBConstr minWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree) throws ContradictionException {
        return MinWatchCardPB.minWatchCardPBNew(s, voc, ps, moreThan, degree, false);
    }

    private static PBConstr minWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree, boolean normalized) throws ContradictionException {
        int mydegree = degree + MinWatchCardPB.linearisation(voc, ps);
        if (ps.size() < mydegree) {
            throw new ContradictionException();
        }
        if (ps.size() == 0 && mydegree > 0) {
            throw new ContradictionException();
        }
        if (ps.size() == mydegree || ps.size() <= 0) {
            int i = 0;
            while (i < ps.size()) {
                if (!s.enqueue(ps.get(i))) {
                    throw new ContradictionException();
                }
                ++i;
            }
            return new UnitClausesPB(ps);
        }
        MinWatchCardPB retour = null;
        retour = normalized ? new MinWatchCardPB(voc, ps, mydegree) : new MinWatchCardPB(voc, ps, moreThan, mydegree);
        if (retour.bigDegree.signum() <= 0) {
            return null;
        }
        retour.computeWatches();
        return (MinWatchCardPB)retour.computePropagation(s);
    }

    public boolean learnt() {
        return this.learnt;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        if (!$assertionsDisabled && !this.learnt) {
            throw new AssertionError();
        }
        this.computeWatches();
    }

    public void assertConstraint(UnitPropagationListener s) {
        int i = 0;
        while (i < this.size()) {
            if (this.getVocabulary().isUnassigned(this.get(i))) {
                boolean ret = s.enqueue(this.get(i), this);
                if (!$assertionsDisabled && !ret) {
                    throw new AssertionError();
                }
            }
            ++i;
        }
    }

    public IVecInt computeAnImpliedClause() {
        return null;
    }
}

