/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="pictureConversion")
public class PictureConversion
implements Comparable<PictureConversion> {
    private static final int DEFAULT_ORDER = 0;
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean DEFAULT_RENDITION_VISIBLE = true;
    private static final boolean DEFAULT_ISRENDITION = true;
    @XNode(value="@id")
    protected String id;
    @XNode(value="@order")
    protected Integer order;
    @XNode(value="@description")
    protected String description;
    @XNode(value="@enabled")
    protected Boolean enabled;
    @XNode(value="@chainId")
    protected String chainId;
    @XNode(value="@tag")
    protected String tag;
    @XNode(value="@maxSize")
    protected Integer maxSize;
    @XNodeList(value="filters/filter-id", type=ArrayList.class, componentType=String.class)
    protected List<String> filterIds;
    @XNode(value="@rendition")
    protected Boolean rendition;
    @XNode(value="@renditionVisible")
    protected Boolean renditionVisible;

    public PictureConversion() {
    }

    public PictureConversion(String id, String description, String tag, Integer maxSize) {
        this.id = id;
        this.description = description;
        this.tag = tag;
        this.maxSize = maxSize;
    }

    public String getId() {
        return this.id;
    }

    public int getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    public String getChainId() {
        return this.chainId;
    }

    @Deprecated
    public String getTitle() {
        return this.id;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public List<String> getFilterIds() {
        return this.filterIds;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public void setFilterIds(List<String> filterIds) {
        this.filterIds = filterIds;
    }

    public boolean isRenditionVisible() {
        return this.renditionVisible == null ? true : this.renditionVisible;
    }

    public boolean isRendition() {
        return this.rendition == null ? true : this.rendition;
    }

    public void setRendition(Boolean rendition) {
        this.rendition = rendition;
    }

    public void setRenditionVisible(Boolean renditionVisible) {
        this.renditionVisible = renditionVisible;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public int compareTo(PictureConversion other) {
        return Integer.compare(this.getOrder(), other.getOrder());
    }

    public PictureConversion clone() {
        PictureConversion clone = new PictureConversion();
        clone.id = this.id;
        clone.description = this.description;
        clone.tag = this.tag;
        clone.maxSize = this.maxSize;
        clone.order = this.order;
        clone.chainId = this.chainId;
        clone.enabled = this.enabled;
        if (this.filterIds != null) {
            clone.filterIds = new ArrayList<String>(this.filterIds);
        }
        clone.rendition = this.rendition;
        clone.renditionVisible = this.renditionVisible;
        return clone;
    }

    public void merge(PictureConversion other) {
        if (other.enabled != null) {
            this.enabled = other.enabled;
        }
        if (!StringUtils.isBlank((CharSequence)other.chainId)) {
            this.chainId = other.chainId;
        }
        if (!StringUtils.isBlank((CharSequence)other.tag)) {
            this.tag = other.tag;
        }
        if (!StringUtils.isBlank((CharSequence)other.description)) {
            this.description = other.description;
        }
        if (other.order != null) {
            this.order = other.order;
        }
        if (other.maxSize != null) {
            this.maxSize = other.maxSize;
        }
        ArrayList<String> newFilterIds = new ArrayList<String>();
        newFilterIds.addAll(this.filterIds);
        newFilterIds.addAll(other.filterIds);
        this.filterIds = newFilterIds;
        if (other.rendition != null) {
            this.rendition = other.rendition;
        }
        if (other.renditionVisible != null) {
            this.renditionVisible = other.renditionVisible;
        }
    }

    public String toString() {
        return String.format("PictureConversion [id=%s, description=%s, tag=%s, maxSize=%d, order=%d, chainId=%s, enabled=%s]", this.id, this.description, this.tag, this.maxSize, this.order, this.chainId, this.enabled);
    }
}

