/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class FlacTagReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private VorbisCommentReader vorbisCommentReader = new VorbisCommentReader();

    public FlacTag read(RandomAccessFile raf) throws CannotReadException, IOException {
        FlacStreamReader flacStream = new FlacStreamReader(raf);
        flacStream.findStream();
        VorbisCommentTag tag = null;
        ArrayList<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();
        boolean isLastBlock = false;
        while (!isLastBlock) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Looking for MetaBlockHeader at:" + raf.getFilePointer());
            }
            MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Reading MetadataBlockHeader:" + mbh.toString() + " ending at " + raf.getFilePointer());
            }
            switch (mbh.getBlockType()) {
                case VORBIS_COMMENT: {
                    byte[] commentHeaderRawPacket = new byte[mbh.getDataLength()];
                    raf.read(commentHeaderRawPacket);
                    tag = this.vorbisCommentReader.read(commentHeaderRawPacket, false);
                    break;
                }
                case PICTURE: {
                    try {
                        MetadataBlockDataPicture mbdp = new MetadataBlockDataPicture(mbh, raf);
                        images.add(mbdp);
                    }
                    catch (IOException ioe) {
                        logger.warning("Unable to read picture metablock, ignoring:" + ioe.getMessage());
                    }
                    catch (InvalidFrameException ive) {
                        logger.warning("Unable to read picture metablock, ignoring" + ive.getMessage());
                    }
                    break;
                }
                default: {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Ignoring MetadataBlock:" + (Object)((Object)mbh.getBlockType()));
                    }
                    raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                }
            }
            isLastBlock = mbh.isLastBlock();
            mbh = null;
        }
        if (tag == null) {
            tag = VorbisCommentTag.createNewTag();
        }
        FlacTag flacTag = new FlacTag(tag, images);
        return flacTag;
    }
}

