/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.recompute;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RecomputeViewsAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "recomputeViews";
    public static final String PARAM_XPATH = "xpath";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(RecomputeViewsComputation::new, Arrays.asList("i1:recomputeViews", "o1:status")).build();
    }

    public static class RecomputeViewsComputation
    extends AbstractBulkComputation {
        public static final String PICTURE_VIEWS_GENERATION_DONE_EVENT = "pictureViewsGenerationDone";
        protected String xpath;

        public RecomputeViewsComputation() {
            super(RecomputeViewsAction.ACTION_NAME);
        }

        public void startBucket(String bucketKey) {
            BulkCommand command = this.getCurrentCommand();
            this.xpath = (String)command.getParam(RecomputeViewsAction.PARAM_XPATH);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            for (String docId : ids) {
                DocumentModel workingDocument;
                Property fileProp;
                Blob blob;
                if (!session.exists((DocumentRef)new IdRef(docId)) || (blob = (Blob)(fileProp = (workingDocument = session.getDocument((DocumentRef)new IdRef(docId))).getProperty(this.xpath)).getValue()) == null) continue;
                String title = workingDocument.getTitle();
                try {
                    PictureResourceAdapter picture = (PictureResourceAdapter)workingDocument.getAdapter(PictureResourceAdapter.class);
                    picture.fillPictureViews(blob, blob.getFilename(), title, null);
                }
                catch (DocumentNotFoundException e) {
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (workingDocument.isVersion()) {
                    workingDocument.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                }
                workingDocument.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
                workingDocument.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
                workingDocument.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
                workingDocument.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
                session.saveDocument(workingDocument);
                DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), workingDocument);
                Event event = ctx.newEvent(PICTURE_VIEWS_GENERATION_DONE_EVENT);
                ((EventService)Framework.getService(EventService.class)).fireEvent(event);
            }
        }
    }
}

