/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.rendition;

import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public class PictureRenditionProvider
implements RenditionProvider {
    public boolean isAvailable(DocumentModel doc, RenditionDefinition definition) {
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        return picture != null && picture.getPictureFromTitle(definition.getName()) != null;
    }

    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) {
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        if (picture == null) {
            return Collections.emptyList();
        }
        Blob blob = picture.getPictureFromTitle(definition.getName());
        return blob != null ? Collections.singletonList(blob) : Collections.emptyList();
    }
}

